<?php /** @noinspection PhpUnused */

defined('MOODLE_INTERNAL') || die();

use local_academic_integrity\infraction;
use local_academic_integrity\ai_flag;
use local_academic_integrity\shared_lib as NED;

/**
 * Return the HTML fragment to show the flag in the navigation bar next to the
 * user menu.
 *
 * @param \renderer_base $renderer See lib/outputrenderers.php:navbar_plugin_output() for details.
 *
 * @return string the HTML fragment ("<div class="..."><span class="..."></span></div>").
 *
 * @noinspection PhpUnusedParameterInspection
 */
function local_academic_integrity_render_navbar_output($renderer) {
    return NED::div(ai_flag::flag(NED::get_userid_or_global()), 'academic-integrity');
}
/**
 * Add nodes to myprofile page.
 *
 * @param \core_user\output\myprofile\tree $tree Tree object
 * @param stdClass $user user object
 * @param bool $iscurrentuser
 * @param stdClass $course Course object
 *
 * @return bool
 *
 * @noinspection PhpUnusedParameterInspection
 */
function local_academic_integrity_myprofile_navigation(\core_user\output\myprofile\tree $tree, $user, $iscurrentuser, $course) {
    if (NED::during_update()) return false;
    if (!NED::can_view_user_ai($user) || !NED::ai_is_student($user)) return false;

    $courseid = $course->id ?? 0;
    $str_name = 'academicintegrityinfractions';
    $category_name = NED::can_add_user_ai($user, true) ?
        NED::link([NED::PAGE_AI_INFRACTIONS, [NED::PAR_USER => $user->id]], $str_name) :
        NED::str($str_name);
    $category = new core_user\output\myprofile\category('academicintegrity', $category_name, 'contact');
    $tree->add_category($category);

    $infractions = new local_academic_integrity\output\datatable_student_infractions($user->id, $courseid);
    $output = NED::get_renderer()->render($infractions);

    $localnode = new core_user\output\myprofile\node('academicintegrity', 'infraction', '', null, null, $output);
    $tree->add_node($localnode);

    return true;
}

/**
 * Map icons for font-awesome themes.
 */
function local_academic_integrity_get_fontawesome_icon_map() {
    return [
        'local_academic_integrity:view' => 'fa-external-link'
    ];
}

/**
 * Serve the files from the local_academic_integrity file areas
 *
 * @param stdClass $course        the course object
 * @param stdClass $cm            the course module object
 * @param stdClass $context       the context
 * @param string   $filearea      the name of the file area
 * @param array    $args          extra arguments (itemid, path)
 * @param bool     $forcedownload do or not force download
 * @param array    $options       additional options affecting the file serving
 *
 * @return bool false if the file not found, just send the file otherwise and do not return anything
 * @noinspection PhpUnusedParameterInspection
 */
function local_academic_integrity_pluginfile($course, $cm, $context, $filearea, $args, $forcedownload, array $options=array()) {
    do {
        if ($context->contextlevel != CONTEXT_SYSTEM) {
            break;
        }

        if ($filearea !== 'uploadedfiles') {
            break;
        }

        require_login();

        // Leave this line out if you set the itemid to null in make_pluginfile_url (set $itemid to 0 instead).
        $itemid = array_shift($args); // The first item in the $args array.
        $infraction = new infraction($itemid);
        if (!$infraction->can_view()){
            break;
        }

        // Extract the filename / filepath from the $args array.
        $filename = array_pop($args); // The last item in the $args array.
        if (!$args) {
            $filepath = '/'; // $args is empty => the path is '/'
        } else {
            $filepath = '/'.implode('/', $args).'/'; // $args contains elements of the filepath
        }

        // Retrieve the file from the Files API.
        $fs = get_file_storage();
        $file = $fs->get_file($context->id, NED::$PLUGIN_NAME, $filearea, $itemid, $filepath, $filename);
        if (!$file) {
            break; // The file does not exist.
        }

        // We can now send the file back to the browser - in this case with a cache lifetime of 1 day and no filtering.
        send_stored_file($file, 86400, 0, $forcedownload, $options);
        return true;
    } while(false);

    return false;
}
