<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package local_academic_integrity
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

global $ADMIN;
if ($hassiteconfig) {
    $settings = new admin_settingpage('local_academic_integrity',
                get_string('pluginname', 'local_academic_integrity'));

    $yesno = array(
        new lang_string('no'),
        new lang_string('yes'),
    );

    $settings->add(new admin_setting_configselect('local_academic_integrity/showacademicintegrityflags',
                get_string('local_academic_integrity_showacademicintegrityflags', 'local_academic_integrity'),
                get_string('local_academic_integrity_showacademicintegrityflags_description', 'local_academic_integrity'),
1, $yesno));

    $settings->add(new admin_setting_configselect('local_academic_integrity/showflagtostudent',
                get_string('local_academic_integrity_showflagtostudent', 'local_academic_integrity'),
                get_string('local_academic_integrity_showflagtostudent_description', 'local_academic_integrity'),
1, $yesno));

    $ADMIN->add('localplugins', $settings);
}
