/* jshint ignore:start */
define(['jquery'], function($) {
    return {
        init: function() {
            $(document).ready(function() {

                $('form#grade_edit').submit(function() {
                    var isvalid = true;

                    $('.grade-input:enabled').each(function() {
                        if (validategrade($(this)) === false) {
                            isvalid = false;
                        }
                    });
                    return isvalid;
                });


                $('.grade-input:enabled').blur(function() {
                    validategrade($(this));
                });

                function validategrade(elem) {
                    var grade = elem.val();
                    var grademax = elem.data('grademax');

                    elem.css('background', '');

                    if (grade) {
                        if (grade > grademax || grade < 0) {
                            elem.css('background', '#ffcdd2');
                            return false;
                        }
                    }
                    return true;
                }

                // Grade table sort.
                $('#page-local-kica-grade_activity table.kicagradingtable tbody tr').sort(function(a, b) {
                    return $(b).data('sort') < $(a).data('sort') ? 1 : -1;
                }).appendTo('#page-local-kica-grade_activity table.kicagradingtable tbody');
            });
        }
    };
});
/* jshint ignore:end */