<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Defines backup_local_kica class.
 *
 * @package     local_kica
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Backup plugin class.
 *
 * @package    local_kica
 * @copyright  2018 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class backup_local_kica_plugin extends backup_local_plugin {

    /**
     * Returns the format information to attach to course element.
     */
    protected function define_course_plugin_structure() {

        $plugin = $this->get_plugin_element();
        $localkica = new backup_nested_element($this->get_recommended_name());

        $localkicadata = new backup_nested_element('localkica', null,
            array(
                'enabled',
                'gradesplit',
                'calculation',
                'nameofseventypercent',
                'nameofthirtypercent',
                'nameoftwentypercent',
                'nameoftenpercent',
                'knowledge',
                'inquiry',
                'communication',
                'application',
                'pullfromgradebook',
                'timemodified',
                'timecreated'
            )
        );

        $localkicaitems = new backup_nested_element('localkicaitems');

        $localkicaitem = new backup_nested_element('localkicaitem', array('id'),
            array(
                'itemid',
                'knowledge',
                'inquiry',
                'communication',
                'application',
                'kicagroup',
                'areaid',
                'timecreated',
                'timemodified'
            )
        );

        $localkicagrades = new backup_nested_element('localkicagrades');

        $localkicagrade = new backup_nested_element('localkicagrade', array('id'),
            array(
                'userid',
                'itemid',
                'usermodified',
                'finalgrade',
                'knowledge',
                'inquiry',
                'communication',
                'application',
                'flag',
                'timecreated',
                'timemodified'
            )
        );

        $plugin->add_child($localkica);
        $localkica->add_child($localkicadata);
        $localkica->add_child($localkicaitems);
        $localkicaitems->add_child($localkicaitem);
        $localkicaitem->add_child($localkicagrades);
        $localkicagrades->add_child($localkicagrade);

        // Set source to populate the data.
        $localkicadata->set_source_table('local_kica', array(
            'courseid' => backup::VAR_PARENTID));

        $localkicaitem->set_source_table('local_kica_grade_items', array('courseid' => backup::VAR_COURSEID));
        $localkicagrade->set_source_table('local_kica_grade_grades', array('courseid' => backup::VAR_COURSEID, 'itemid' => backup::VAR_PARENTID));

        $localkicaitem->annotate_ids('grade_item', 'itemid');
        $localkicaitem->annotate_ids('area', 'areaid');

        $localkicagrade->annotate_ids('user', 'userid');

        return $plugin;
    }
}
