<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Assign role to cohort form.
 *
 * @package    tool_cohortroles
 * @copyright  2018 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_kica\form;

defined('MOODLE_INTERNAL') || die();

use local_kica\kica_grade;
use moodleform;
use context_system;
use html_writer;
use moodle_url;

global $CFG;
require_once($CFG->libdir . '/formslib.php');

/**
 * KICA course setting form.
 *
 * @package    local_kica
 * @copyright  2018 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class coursesettings extends moodleform {
    /**
     * @throws \coding_exception
     * @throws \moodle_exception
     */
    public function definition() {

        $mform = $this->_form;

        $mform->addElement('advcheckbox', 'enabled', '', get_string('enablekicainthiscourse', 'local_kica'));

        $mform->addElement('select', 'gradesplit', get_string('gradesplit', 'local_kica'), [kica_grade::SPLIT_7030 => '70-30', kica_grade::SPLIT_702010 => '70-20-10']);

        $mform->addElement('text', 'nameofseventypercent', get_string('nameofseventypercent', 'local_kica'));
        $mform->setType('nameofseventypercent', PARAM_TEXT);
        $mform->setDefault('nameofseventypercent', get_string('coursework', 'local_kica'));

        $mform->addElement('text', 'nameofthirtypercent', get_string('nameofthirtypercent', 'local_kica'));
        $mform->setType('nameofthirtypercent', PARAM_TEXT);
        $mform->setDefault('nameofthirtypercent', get_string('finalexam', 'local_kica'));
        $mform->hideIf('nameofthirtypercent', 'gradesplit', 'eq', kica_grade::SPLIT_702010);

        $mform->addElement('text', 'nameoftwentypercent', get_string('nameoftwentypercent', 'local_kica'));
        $mform->setType('nameoftwentypercent', PARAM_TEXT);
        $mform->setDefault('nameoftwentypercent', get_string('finalexam', 'local_kica'));
        $mform->hideIf('nameoftwentypercent', 'gradesplit', 'eq', kica_grade::SPLIT_7030);

        $mform->addElement('text', 'nameoftenpercent', get_string('nameoftenpercent', 'local_kica'));
        $mform->setType('nameoftenpercent', PARAM_TEXT);
        $mform->setDefault('nameoftenpercent', get_string('finalproject', 'local_kica'));
        $mform->hideIf('nameoftenpercent', 'gradesplit', 'eq', kica_grade::SPLIT_7030);

        $mform->addElement('advcheckbox', 'pullfromgradebook', '', get_string('pullfromgradebook', 'local_kica'), array('group' => 1), array(0, 1));
        $mform->addHelpButton('pullfromgradebook', 'pullfromgradebook', 'local_kica');

        $mform->addElement('header', 'kicadistribution', get_string('kicadistribution', 'local_kica'));

        $mform->addElement('select', 'calculation', get_string('kicacalculation', 'local_kica'), [
            kica_grade::CALCULATION_NATURAL => get_string('natural', 'local_kica'),
            kica_grade::CALCULATION_WEIGHTED => get_string('weighted', 'local_kica'),
        ]);

        $attributes = array('size'=>'5');
        $mform->addElement('text', 'knowledge', get_string('knowledge', 'local_kica'), $attributes);
        $mform->setType('knowledge', PARAM_INT);
        $mform->hideIf('knowledge', 'calculation', 'eq', kica_grade::CALCULATION_NATURAL);

        $mform->addElement('text', 'inquiry', get_string('inquiry', 'local_kica'), $attributes);
        $mform->setType('inquiry', PARAM_INT);
        $mform->hideIf('inquiry', 'calculation', 'eq', kica_grade::CALCULATION_NATURAL);

        $mform->addElement('text', 'communication', get_string('communication', 'local_kica'), $attributes);
        $mform->setType('communication', PARAM_INT);
        $mform->hideIf('communication', 'calculation', 'eq', kica_grade::CALCULATION_NATURAL);

        $mform->addElement('text', 'application', get_string('application', 'local_kica'), $attributes);
        $mform->setType('application', PARAM_INT);
        $mform->hideIf('application', 'calculation', 'eq', kica_grade::CALCULATION_NATURAL);

        $mform->addElement('hidden', 'courseid');
        $mform->setType('courseid', PARAM_INT);

        $mform->addElement('hidden', 'id');
        $mform->setType('id', PARAM_INT);

        $this->add_action_buttons();
    }

    /**
     * @param array $data
     * @param array $files
     * @return array
     */
    public function validation($data, $files) {
        $errors = array();

        if ($data['gradesplit'] == kica_grade::SPLIT_7030) {
            if (empty($data['nameofseventypercent'])) {
                $errors['nameofseventypercent'] = get_string('err_required', 'form');
            }
            if (empty($data['nameofthirtypercent'])) {
                $errors['nameofthirtypercent'] = get_string('err_required', 'form');
            }
        }

        if ($data['gradesplit'] == kica_grade::SPLIT_702010) {
            if (empty($data['nameofseventypercent'])) {
                $errors['nameofseventypercent'] = get_string('err_required', 'form');
            }
            if (empty($data['nameoftwentypercent'])) {
                $errors['nameoftwentypercent'] = get_string('err_required', 'form');
            }
            if (empty($data['nameoftenpercent'])) {
                $errors['nameoftenpercent'] = get_string('err_required', 'form');
            }
        }

        if ($data['calculation'] == kica_grade::CALCULATION_WEIGHTED) {
            if (empty($data['knowledge'])) {
                $errors['knowledge'] = get_string('errornonzero', 'local_kica');
            }

            if (empty($data['inquiry'])) {
                $errors['inquiry'] = get_string('errornonzero', 'local_kica');
            }

            if (empty($data['communication'])) {
                $errors['communication'] = get_string('errornonzero', 'local_kica');
            }

            if (empty($data['application'])) {
                $errors['application'] = get_string('errornonzero', 'local_kica');
            }

            if (($data['knowledge'] + $data['inquiry'] + $data['communication'] + $data['application']) > 100) {
                $errors['knowledge'] = get_string('kicadistributiongreater', 'local_kica');
            }
            if (($data['knowledge'] + $data['inquiry'] + $data['communication'] + $data['application']) < 100) {
                $errors['knowledge'] = get_string('kicadistributionless', 'local_kica');
            }
        }

        return $errors;
    }

}
