<?php
/**
 * @package    local_kica
 * @subpackage NED
 * @copyright  NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_kica as kica;
use local_kica\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot.'/local/kica/lib.php');
/**
 * Event observers.
 */
class local_kica_observer
{
    /**
     * Event processor - user_graded added.
     * @param \core\event\user_graded $event
     */
    public static function user_graded(\core\event\user_graded $event){
        static $_data = [];
        $gg = $event->get_grade();
        if (!$gg || isset($_data[$gg->userid][$gg->itemid])){
            return;
        }

        $_data[$gg->userid][$gg->itemid] = true;
        $gi = $gg->grade_item;

        // check kica zero
        $finalgrade = $gg->overridden > 0 ? $gg->finalgrade : $gg->rawgrade;
        $check_kica_zero = is_numeric($finalgrade) && $finalgrade == 0 && $gg->excluded == 0;
        $remove_kica_grade = (is_null($finalgrade) || $gg->excluded > 0);
        do {
            if ($gi->itemtype != 'mod'){
                break;
            }
            if (!($check_kica_zero || $remove_kica_grade)){
                break;
            }

            $kica = NED::get_kica_enabled($gi->courseid);
            if (!$kica){
                break;
            }

            $kgi = NED::ki_get_by_grade_item($gi);
            if (empty($kgi->id)){
                break;
            }

            $kicagrade = kica\kica_grade::get_by_userid_itemid($gg->userid, $kgi->id);
            if (empty($kicagrade->id)) {
                break;
            }

            if ($check_kica_zero){
                if ($kicagrade->is_graded() || !$kicagrade->is_gradable()){
                    // it has been graded already or can't be graded
                    break;
                }

                $kicagrade->set_zero();
                $kicagrade->update_record();
            } elseif ($remove_kica_grade){
                if (!$kicagrade->is_graded()){
                    // there is no graded
                    break;
                }
                $kicagrade->delete_record();
            }
        } while (false);

    }
}
