<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * KICA
 *
 * @package     local_kica
 * @category    string
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_kica as kica;
use local_kica\output\menu_bar as KMB;
use local_kica\shared_lib as NED;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot.'/local/kica/lib.php');

$KMB = new KMB(KMB::PAGE_KICA_SETTINGS, [], null, true);
$KMB->show_error_for_not_teacher();
$courseid = $KMB->courseid;

// Security.
$KMB->show_error_for_not_teacher(['moodle/grade:edit', NED::get_full_capability('manage')]);

// Page boilerplate stuff.
$redirecturl = $KMB->get_url(KMB::PAGE_KICA_ACTIVITIES);
$KMB->set_page_params();

// Set up the form.
$mform = new kica\form\coursesettings();

$kica = NED::get_kica($courseid);
$kicaitem = kica\kica_item::get_course_item($courseid);

if ($mform->is_cancelled()) {
    redirect($redirecturl);
} else if ($data = $mform->get_data() ) {
    if (isset($data->knowledge)) {
        $kicaitem->knowledge = $data->knowledge;
    }
    if (isset($data->inquiry)) {
        $kicaitem->inquiry = $data->inquiry;
    }
    if (isset($data->communication)) {
        $kicaitem->communication = $data->communication;
    }
    if (isset($data->application)) {
        $kicaitem->application = $data->application;
    }

    if ($kicaitem->id) {
        $kicaitem->timemodified = time();
        $kicaitem->update();
    } else {
        $kicaitem->timecreated = time();
        $kicaitem->insert();
    }

    if ($kica) {
        $data->timemodified = time();
        $DB->update_record('local_kica', $data);
        $table = kica\kica_item::TABLE;
        if ($data->gradesplit == kica\kica_grade::SPLIT_702010) {
            $DB->execute("UPDATE {{$table}} SET kicagroup = :kicagroup WHERE courseid = :courseid AND kicagroup = 30",
                ['kicagroup' => 20, 'courseid' => $courseid]);
        } else { // get kica\grade::SPLIT_7030 by default
            $DB->execute("UPDATE {{$table}} SET kicagroup = :kicagroup WHERE courseid = :courseid AND kicagroup IN (20,10)",
                ['kicagroup' => 30, 'courseid' => $courseid]);
        }
    } else {
        $data->timecreated = time();
        $DB->insert_record('local_kica', $data);
    }
    redirect($redirecturl);
    exit;
}
if (!$kica) {
    $kica = new stdClass();
    $kica->courseid = $courseid;
}

$mform->set_data($kica);

echo $OUTPUT->header();
$KMB->render();
echo html_writer::start_div('kica-main');
$KMB->render_kica_selector_menu();
$KMB->print_grading_errors();
$mform->display();
echo html_writer::end_div();
echo $OUTPUT->footer();
