<?php
/**
 * @package    local_kica
 * @subpackage NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use \local_kica\shared_lib as NED;

/**
 * All upgrades checks from Moodle 3
 *
 * @param int $oldversion
 */
function local_kica_moodle3_upgrades($oldversion): void{
    global $DB;
    $dbman = $DB->get_manager();

    if ($oldversion < 2019010201) {
        $removedfields = array('courseid', 'categoryid', 'itemname', 'itemtype', 'itemmodule', 'iteminstance', 'grademax', 'grademin',
                               'gradepass', 'sortorder', 'display', 'decimals', 'needsupdate');


        $table = new xmldb_table('local_kica_grade_items');
        foreach ($removedfields as $removedfield) {
            $field = new xmldb_field($removedfield);
            if ($dbman->field_exists($table, $field)) {
                $dbman->drop_field($table, $field);
            }
        }

        // Define field itemid to be added to local_kica_grade_items.
        $table = new xmldb_table('local_kica_grade_items');
        $field = new xmldb_field('itemid', XMLDB_TYPE_INTEGER, '11', null, null, null, null, 'id');

        // Conditionally launch add field itemid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Kica savepoint reached.
        upgrade_plugin_savepoint(true, 2019010201, 'local', 'kica');
    }

    if ($oldversion < 2019011500) {

        // Define field pullfromgradebook to be added to local_kica.
        $table = new xmldb_table('local_kica');
        $field = new xmldb_field('pullfromgradebook', XMLDB_TYPE_INTEGER, '1', null, null, null, '0', 'application');

        // Conditionally launch add field pullfromgradebook.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Kica savepoint reached.
        upgrade_plugin_savepoint(true, 2019011500, 'local', 'kica');
    }

    if ($oldversion < 2019011900) {

        // Rename field course on table local_kica to courseid.
        $table = new xmldb_table('local_kica');
        $field = new xmldb_field('course', XMLDB_TYPE_INTEGER, '11', null, XMLDB_NOTNULL, null, '0', 'id');
        // Launch rename field courseid.
        $dbman->rename_field($table, $field, 'courseid');

        // Rename field updategradebook on table local_kica to pullfromgradebook.
        $table = new xmldb_table('local_kica');
        $field = new xmldb_field('updategradebook', XMLDB_TYPE_INTEGER, '1', null, null, null, '0', 'application');
        // Launch rename field pullfromgradebook.
        $dbman->rename_field($table, $field, 'pullfromgradebook');

        // Define field courseid to be added to local_kica_grade_grades.
        $table = new xmldb_table('local_kica_grade_grades');
        $field = new xmldb_field('courseid', XMLDB_TYPE_INTEGER, '11', null, XMLDB_NOTNULL, null, '0', 'id');
        // Conditionally launch add field courseid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field courseid to be added to local_kica_grade_items.
        $table = new xmldb_table('local_kica_grade_items');
        $field = new xmldb_field('courseid', XMLDB_TYPE_INTEGER, '11', null, XMLDB_NOTNULL, null, '0', 'id');
        // Conditionally launch add field courseid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }


        // Kica savepoint reached.
        upgrade_plugin_savepoint(true, 2019011900, 'local', 'kica');
    }

    if ($oldversion < 2019022600) {

        // Define field areaid to be added to local_kica_grade_items.
        $table = new xmldb_table('local_kica_grade_items');
        $field = new xmldb_field('areaid', XMLDB_TYPE_INTEGER, '11', null, null, null, '0', 'kicagroup');

        // Conditionally launch add field areaid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Kica savepoint reached.
        upgrade_plugin_savepoint(true, 2019022600, 'local', 'kica');
    }

    if ($oldversion < 2019031000) {
        $DB->execute('UPDATE {local_kica_grade_items} SET nonkica = 70 WHERE nonkica = 0');
        $DB->execute('UPDATE {local_kica_grade_items} SET nonkica = 30 WHERE nonkica = 1');

        // Rename field nameforkicaactivities on table local_kica to nameofseventypercent.
        $table = new xmldb_table('local_kica');
        $field = new xmldb_field('nameforkicaactivities', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'enabled');
        // Launch rename field nameforkicaactivities.
        $dbman->rename_field($table, $field, 'nameofseventypercent');

        // Rename field namefornonkicaactivities on table local_kica to nameofthirtypercent.
        $table = new xmldb_table('local_kica');
        $field = new xmldb_field('namefornonkicaactivities', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'nameofseventypercent');
        // Launch rename field namefornonkicaactivities.
        $dbman->rename_field($table, $field, 'nameofthirtypercent');

        // Rename field nonkica on table local_kica_grade_items to kicagroup.
        $table = new xmldb_table('local_kica_grade_items');
        $field = new xmldb_field('nonkica', XMLDB_TYPE_INTEGER, '2', null, null, null, '0', 'application');
        // Launch rename field nonkica.
        $dbman->rename_field($table, $field, 'kicagroup');

        // Kica savepoint reached.
        upgrade_plugin_savepoint(true, 2019031000, 'local', 'kica');
    }

    if ($oldversion < 2019040701) {

        // Define field flag to be added to local_kica_grade_grades.
        $table = new xmldb_table('local_kica_grade_grades');
        $field = new xmldb_field('flag', XMLDB_TYPE_INTEGER, '4', null, XMLDB_NOTNULL, null, '0', 'application');

        // Conditionally launch add field flag.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Kica savepoint reached.
        upgrade_plugin_savepoint(true, 2019040701, 'local', 'kica');
    }

    if ($oldversion < 2020041800) {

        // Define field gradesplit to be added to local_kica.
        $table = new xmldb_table('local_kica');
        $field = new xmldb_field('gradesplit', XMLDB_TYPE_INTEGER, '2', null, XMLDB_NOTNULL, null, '0', 'enabled');

        // Conditionally launch add field gradesplit.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field nameoftwentypercent to be added to local_kica.
        $table = new xmldb_table('local_kica');
        $field = new xmldb_field('nameoftwentypercent', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'nameofthirtypercent');

        // Conditionally launch add field nameoftwentypercent.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field nameoftenpercent to be added to local_kica.
        $table = new xmldb_table('local_kica');
        $field = new xmldb_field('nameoftenpercent', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'nameoftwentypercent');

        // Conditionally launch add field nameoftenpercent.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // initialize defaulty value.
        $DB->execute("UPDATE {local_kica} SET gradesplit =?", [\local_kica\kica_grade::SPLIT_7030]);

        // Kica savepoint reached.
        upgrade_plugin_savepoint(true, 2020041800, 'local', 'kica');
    }

    if ($oldversion < 2020041900) {

        // Define field gradesplit to be added to local_kica.
        $table = new xmldb_table('local_kica');
        $field = new xmldb_field('calculation', XMLDB_TYPE_INTEGER, '2', null, XMLDB_NOTNULL, null, '0', 'gradesplit');

        // Conditionally launch add field gradesplit.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }
        // initialize defaulty value.
        $DB->execute("UPDATE {local_kica} SET calculation =?", [\local_kica\kica_grade::CALCULATION_WEIGHTED]);

        // Kica savepoint reached.
        upgrade_plugin_savepoint(true, 2020041900, 'local', 'kica');
    }

    if ($oldversion < 2020063000) {
        // set all kica grades, which have zero in moodle gradebook - to zero in kica gradebook
        $records = $DB->get_records_sql("
            SELECT 
                CONCAT(gg.userid, ki.id) AS unicid,
                gg.userid, 
                ki.id AS kicaitemid,
                k.pullfromgradebook
            FROM {local_kica} AS k
            LEFT JOIN {local_kica_grade_items} AS ki 
                ON ki.courseid = k.courseid
            LEFT JOIN {grade_items} AS gi 
                ON gi.id = ki.itemid 
                AND gi.courseid = ki.courseid 
            LEFT JOIN {grade_grades} AS gg 
                ON gg.itemid = gi.id
            LEFT JOIN {user} AS u 
                ON gg.userid = u.id
            LEFT JOIN {local_kica_grade_grades} AS kg
                ON kg.itemid = ki.id 
                AND kg.userid = gg.userid
            WHERE k.enabled = 1
                AND gi.itemtype = 'mod'
                AND gg.excluded = 0
                AND (
                  kg.finalgrade IS NULL OR 
                  (ki.knowledge > 0 AND kg.knowledge IS NULL) OR 
                  (ki.inquiry > 0 AND kg.inquiry IS NULL) OR 
                  (ki.communication > 0 AND kg.communication IS NULL) OR 
                  (ki.application > 0 AND kg.application IS NULL)
                ) 
                AND (
                  (gg.overridden > 0 AND gg.finalgrade = 0) OR 
                  (gg.overridden = 0 AND gg.rawgrade = 0) 
                )
        ");

        foreach ($records as $record){
            $kicagrade = local_kica\kica_grade::get_by_userid_itemid($record->userid, $record->kicaitemid);
            if (empty($kicagrade->id)) continue;

            $kicagrade->set_zero();
            $kicagrade->update_record();
        }

        upgrade_plugin_savepoint(true, 2020063000, 'local', 'kica');
    }

    if ($oldversion < 2021120300){
        $table = new xmldb_table('local_kica_grade_grades');
        $field = new xmldb_field('reduction');

        if ($dbman->field_exists($table, $field)) {
            local_ned_controller\task\disposable_adhoc_task::add_new_job('local_kica_import_table_reduction_in_ngc',
                '', '', [], 0, null,
                __DIR__ . '/upgradelib.php'
            );
        }

        // Kica savepoint reached.
        upgrade_plugin_savepoint(true, 2021120300, 'local', 'kica');
    }

    if ($oldversion < 2021120600){
        // Field reduction will be removed from local_kica_grade_grades.
        $table = new xmldb_table('local_kica_grade_grades');
        $field = new xmldb_field('reduction');
        if ($dbman->field_exists($table, $field)) {
            $dbman->drop_field($table, $field);
        }

        // Kica savepoint reached.
        upgrade_plugin_savepoint(true, 2021120600, 'local', 'kica');
    }
}

function local_kica_clear_table_records(){
    global $DB;
    $clear_sql = [];
    $clear_sql[] = "
        DELETE k        
        FROM {local_kica} k
        LEFT JOIN {course} course
            ON course.id = k.courseid
        WHERE course.id IS NULL
    ";
    $clear_sql[] = "
        DELETE kgi      
        FROM {local_kica_grade_items} kgi
        LEFT JOIN {course} course
            ON course.id = kgi.courseid
        LEFT JOIN {grade_items} gi
            ON gi.id = kgi.itemid
        WHERE course.id IS NULL OR (kgi.itemid > 0 AND gi.id IS NULL)
    ";
    $clear_sql[] = "
        DELETE kgi      
        FROM {local_kica_grade_grades} kgg
        LEFT JOIN {course} course
            ON course.id = kgg.courseid
        LEFT JOIN {user} u
            ON u.id = kgg.userid
        LEFT JOIN {local_kica_grade_items} kgi
            ON kgi.id = kgg.itemid
        WHERE course.id IS NULL OR u.id IS NULL OR (kgg.itemid > 0 AND kgi.id IS NULL)
    ";

    foreach ($clear_sql as $sql){
        $DB->execute($sql);
    }
}

function local_kica_import_table_reduction_in_ngc(){
    global $DB;
    local_kica_clear_table_records();

    $NGC = NED::$ned_grade_controller;
    $records = $DB->get_records_select('local_kica_grade_grades', 'itemid > 0 AND reduction > 0');
    foreach ($records as $record){
        $kg = NED::kg_get_by_id($record->id);
        if (empty($kg->kica_grade_item->cm->id)) continue;

        $data = new \stdClass();
        $data->courseid = $record->courseid;
        $data->grade_type = $NGC::GT_DEDUCTION;
        $data->cmid = $kg->kica_grade_item->cm->id;
        $data->grade_change = $record->reduction;
        $data->userid = $record->userid;
        $data->reason = $NGC::REASON_OTHER;
        $data->note = 'SYSTEM: Automatically imported record from the KICA gradebook.';
        try {
            $NGC::check_and_save($data);
        } catch(\Exception $e){
            continue;
        }
    }
}
