<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * KICA
 *
 * @package     local_kica
 * @category    string
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_kica as kica;
use local_kica\output\menu_bar as KMB;
use local_kica\shared_lib as NED;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot.'/local/kica/lib.php');

$mode = optional_param(kica\P_MODE, kica\MODE_VIEW, PARAM_RAW);
if ($mode != kica\MODE_EDIT){
    $mode = kica\MODE_VIEW;
}
$filter = optional_param(kica\P_FILTER, '', PARAM_TEXT);
$itemid = optional_param(kica\P_ITEM, 0, PARAM_INT);

$KMB = new KMB(KMB::PAGE_KICA_GRADE_ACTIVITY, [kica\P_MODE => $mode, kica\P_FILTER => $filter, kica\P_ITEM => $itemid]);
$KMB->show_error_for_not_teacher();
$courseid = $KMB->courseid;
$groupid = $KMB->groupid;
$group_students = $KMB->students;

$item = NED::ki_get_by_id_existing($itemid, ['courseid' => $courseid]);
$itemid = $item ? $itemid : 0;

// Security.
$isgrader = $KMB->isteacher && has_capability('moodle/grade:edit', $KMB->context);

// Does not allow edit mode.
if (!$isgrader) {
    $mode = kica\MODE_VIEW;
}

if (!local_kica\helper::iskicaready($courseid)) {
    redirect($KMB->get_url(KMB::PAGE_KICA_ACTIVITIES));
}

$KMB->set_page_params();

/** @var local_kica\output\renderer $renderer */
$renderer = NED::get_renderer();

$r_out = '';
$action_form = [];
if ($groupid >= 0 && !empty($group_students)){
    $action_form[] = $renderer->gradeitem_menu($courseid, $KMB->get_url(KMB::PAGE_KICA_GRADE_ACTIVITY), $itemid);

    if ($itemid){
        $r_out = $renderer->print_grade_activity($courseid, $groupid, $itemid, $group_students, $filter, $mode,
            $isgrader, $action_form, true);
    } else {
        $r_out = $renderer->print_all_activity_grades($courseid, $group_students, true);
    }
} else {
    $r_out .= NED::notification('nostudents', NED::NOTIFY_WARNING);
}

echo $OUTPUT->header();
// control panel
$KMB->render();
$o = $KMB->render_kica_selector_menu(true);

$hasflaggedgrade = false;
if (!empty($item->id)){
    $hasflaggedgrade = $item->activity_has_flagged_grade(array_keys($group_students));
}

if ($isgrader && !$hasflaggedgrade) {
    $o .= $KMB->print_grading_errors(true);
}

if (!empty($action_form)){
    $o .= NED::div($action_form, 'grade-action-form');
}

if ($isgrader && $hasflaggedgrade && $itemid) {
    $o .= NED::div(NED::str('kicarangeswerechanged'), 'alert alert-error alert-block grading-errors');
}

$o .= $r_out;

echo NED::div($o, 'kica-main');
echo $OUTPUT->footer();
