<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * KICA
 *
 * @package     local_kica
 * @category    Zero Grades
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_kica as kica;
use local_kica\helper;
use local_kica\shared_lib as NED;
use local_kica\output\menu_bar as KMB;
use local_kicaquizgrading\helper as KGH;
use local_kicaquizgrading\observer as KGO;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot.'/local/kica/lib.php');
require_once($CFG->dirroot.'/grade/grading/lib.php');
require_once($CFG->dirroot.'/grade/grading/form/lib.php');
require_once($CFG->dirroot.'/grade/grading/form/kica/lib.php');

// Security.
$KMB = KMB::get_menu_bar('/local/kica/recalculate');
$KMB->show_error_for_not_teacher(['moodle/grade:edit']);

if (!is_siteadmin()) {
    NED::print_module_error('nopermissions', 'error', '', get_string('checkpermissions', 'core_role'));
}

$courseid = optional_param('courseid', 0, PARAM_INT);
$itemid = optional_param('itemid', 0, PARAM_INT);
$process = optional_param('process', 0, PARAM_INT);

$thispageurl = new moodle_url('/local/kica/recalculate.php', ['courseid' => $courseid, 'itemid' => $itemid]);
$redirecturl = new moodle_url('/local/kica/grade_activity.php', ['courseid' => $courseid, 'itemid' => $itemid]);

if (!helper::iskicaready($courseid)) {
    redirect($KMB->get_url(KMB::PAGE_KICA_ACTIVITIES));
}

$KMB->set_page_params(NED::str('recalculatekicascores'));

$kicaitem = new \local_kica\kica_item(['id' => $itemid]);

if ($kicaitem->itemtype != 'mod' || ($kicaitem->itemmodule != 'assign' && $kicaitem->itemmodule != 'quiz')) {
    NED::print_module_error('nopermissions', 'error', '', get_string('checkpermissions', 'core_role'));
}

if ($process) {
    if ($kicaitem->itemmodule == 'quiz') {
        $quiz = $DB->get_record('quiz', ['id' => $kicaitem->iteminstance]);
        $sql = 'SELECT DISTINCT qa.userid FROM {quiz_attempts} qa WHERE qa.quiz = ? AND qa.state = ? AND qa.sumgrades IS NOT NULL';
        if (!$cm = get_coursemodule_from_instance('quiz', $quiz->id)) {
            redirect($redirecturl);
        }
        if (!KGH::quiz_has_kica_tag($cm->id)) {
            redirect($redirecturl);
        }
        if ($users = $DB->get_records_sql($sql, [$quiz->id, 'finished'])) {
            foreach ($users as $userid => $d) {
                $attempts = quiz_get_user_attempts($quiz->id, $userid);
                $attempt = KGO::get_graded_attempt($quiz, $attempts);
                if (!($attempt->id ?? false)) {
                    continue;
                }
                $attemptobj = \quiz_attempt::create($attempt->id);
                KGH::update_kica_gradebook($attemptobj);
            }
        }
        helper::clear_activity_kica_flag($kicaitem->id);
    } else if ($kicaitem->itemmodule == 'assign') {
        $sql = "SELECT crit.id critid,
                       crit.category criteriacategory,
                       crit.description creterianame,
                       crit.score maxscore,
                       ga.id areaid,
                       gd.id definitionid
                  FROM {assign} asg
                  JOIN {course_modules} cm ON cm.instance = asg.id
                  JOIN {context} ctx ON ctx.instanceid = cm.id
                  JOIN {grading_areas} ga ON ctx.id=ga.contextid
                  JOIN {grading_definitions} gd ON ga.id = gd.areaid
                  JOIN {gradingform_kica_criteria} crit ON crit.definitionid = gd.id
                 WHERE cm.id = ?
              ORDER BY crit.sortorder ASC";

        if (!$criteria = $DB->get_records_sql($sql, [$kicaitem->cm->id])) {
            redirect($redirecturl, 'criteriaerror');
        }

        $first = reset($criteria);

        $controller = new \gradingform_kica_controller($kicaitem->context, 'mod_assign', 'submissions', $first->areaid);
        $menu = make_grades_menu(100);
        $controller->set_grade_range($menu);

        $data = new \gradingform_kica\data($kicaitem->cm, false, true);
        if ($userids = $data->get_course_users()) {
            foreach ($userids as $user) {
                $userattemptdata = $data->get_user_data($user->id);
                $userattemptdata = reset($userattemptdata);
                if (!empty($userattemptdata)) {
                    $userattemptdata = reset($userattemptdata);
                    $instancerec = $DB->get_record('grading_instances', array('id' => $userattemptdata->instanceid), '*', MUST_EXIST);
                    $instance = new \gradingform_kica_instance($controller, $instancerec);
                    $instance->get_grade(); // It regrades the KICA scores.
                }
            }
        }
        helper::clear_activity_kica_flag($kicaitem->id);
    }
    redirect($redirecturl);
    die;
} else {
    echo $OUTPUT->header();

    echo html_writer::tag('h1', NED::str('recalculatekicascores'), array('class' => 'page-title'));
    $continueurl = clone $thispageurl;
    $continueurl->param('process', 1);
    echo $OUTPUT->confirm(
        get_string('recalculateconfirm', 'local_kica', $kicaitem->itemname),
        $continueurl,
        $redirecturl
    );
    echo $OUTPUT->footer();
}