<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Filter
 *
 * @package    local_kicaquizgrading
 * @copyright  2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_kicaquizgrading\output;

defined('MOODLE_INTERNAL') || die();

use \local_kicaquizgrading\helper;
use \local_kicaquizgrading\shared_lib as NED;

/**
 * Class filter
 * @package local_kicaquizgrading\output
 */
class toprightinfo implements \renderable, \templatable {

    protected $cm;

    /**
     * filter constructor.
     * @param $cm
     */
    public function __construct($cm) {
        $this->cm = $cm;
    }

    /**
     * Export page contents for template
     * @param \renderer_base $output
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output) {
        $data = new \stdClass();
        $kicagradeitem = NED::ki_get_by_cm($this->cm);
        if (empty($kicagradeitem->id)){
            return $data;
        }

        $data->id = $kicagradeitem->id;
        $data->grademax = $kicagradeitem->get_grademax(false, 1);
        foreach (NED::KICA_KEYS as $kica_key){
            $data->$kica_key = $kicagradeitem->get_section($kica_key, false, 1);
        }

        $data->kicagradebook = (new \moodle_url('/local/kica/grade_activity.php', [
            'courseid' => $this->cm->course,
            'user' => 0,
            'cm_students' => 0,
            'prevpage' => 'grade_activity',
            'lock_user' => '',
            'tag' => 'tags_all',
            'mode' => '0',
            'filter' => '',
            'itemid' => $kicagradeitem->id,
        ]))->out(false);

        return $data;
    }
}