define(['jquery', 'core/log'], function($, log) { return {
init: function() {
    $(document).ready(function(){
        let $ned_container = $('form .form-group.ned-select-elements');
        let $ned_container_group = $ned_container.find('.felement[data-fieldtype=group] > fieldset > div');
        let $main_groups = $ned_container_group.children('.ned-add-base-element');
        let $list = $ned_container_group.children('.ned-list-elements');

        // Add close button for elements, which was rendered by server
        add_close_button($ned_container.find('.ned-add-element:not(.ned-add-base-element)'));

        // Add element by selector
        $ned_container.find('.ned-selector-elements').bind('change', function(event){
            let name = event.target.value;
            event.target.value = 0;
            let $main_group = $(event.target).closest($ned_container);
            let groupname = $main_group.data('groupname') + `[${name}]`;
            let $add_element = $main_groups.filter(`[data-groupname = "${groupname}"]`);
            if (!$add_element.length){
                return false;
            }

            $add_element = $add_element.clone();
            $add_element.removeClass('ned-add-base-element');
            add_close_button($add_element);
            $list.append($('<li></li>').append($add_element));
        });

        // update our element names before post data to server
        $ned_container.closest('form').bind('submit', function(){
            $list.each(function(){
                let $elem = $(this);
                let groupname = $elem.closest($ned_container).data('groupname');
                let name, i = 0;
                $elem.find('li > .ned-add-element').each(function(){
                    let $elem = $(this);
                    name = groupname + `[${i}]`;
                    $elem.attr('name', name);
                    $elem.find('[data-nedtype]').each(function(){
                        let $elem = $(this);
                        let postfix = '[' + $elem.data('nedtype') + ']';
                        if ($elem.data('duration')){
                            postfix += '[duration-' + this.nodeName.toLowerCase() + ']';
                        }
                        $elem.attr('name', name + postfix);
                    });
                    i++;
                });
            });
        });

        // close_button functionality
        $ned_container.delegate('.ned-remove-element', 'click', function(event){
            $(event.target).closest('li > .ned-add-element').parent().remove();
        });
    });

    function add_close_button($elems) {
        $elems.each(function() {
            $(this).append($('<div class="ned-remove-element">×</div>'))
        })
    }
}
};});
