define(['jquery', 'core/modal_factory', 'core/templates', 'core/str'], function($, ModalFactory, Templates, str) {
    return {
        init: function(selector) {
            const plugin_name = 'local_ned_controller';
            var elems = $(selector);
            elems.on('click', function(e) {
                e.preventDefault();
                let elem = $(this);
                let data = {};
                [data.summative_score, data.formative_score, data.divided_score, data.participationpower, data.pp_status] =
                    elem.data('data').split(' ');
                ModalFactory.create({
                    type: ModalFactory.types.SAVE_CANCEL,
                    title: str.get_string('participationpower_modal:title', plugin_name, elem.data('course')),
                    body: Templates.render(plugin_name + '/participation_power_modal_body', data),
                }).then(function(modal) {
                    modal.getModal().addClass(plugin_name + '_participationpower_modal');
                    modal.setSaveButtonText(str.get_string('close', plugin_name));
                    modal.show();
                });
            });
        }
    };
});