define(['jquery', 'core/ajax', 'core/log'], function($, Ajax, log) { return {
init: function(userid, courseid, confirm_text) {

    $(document).ready(function(){
        $('.ned_revoke_badge').bind('click', function(e){
            e.preventDefault();
            if (!confirm(confirm_text)){
                return false;
            }

            let $target = $(e.target);
            let data = {
                userid: userid,
                hash: $target.data('hash'),
                courseid: courseid,
            };

            Ajax.call([{ methodname: 'local_ned_controller_badge_revoke', args: {badge_params: data} }])[0]
                .done(function(response) {
                    $target.closest('.nd-block-badge').remove();
                })
                .fail(function(ex) {
                    let message = ex.message ? ex.message : ex.error;
                    log.debug(`Failed: \n${message}\n${ex.debuginfo}\n${ex.backtrace}`);
                });

            return false;
        });
    });
}
};});
