define(['jquery', 'core/templates', 'core/ajax', 'core/log'], function($, Templates, Ajax, log) {
    const animation_length_def = 300;
    let animation_length = animation_length_def;
    let inited = false;
    let $parent, $notes;

    let i_last, notes_html, notes_ready, note_calls, uniq_key;
    let elems_closed = 0;
    // NED_Notify
    return {
        init: function() {
            if (inited) return;
            inited = true;

            $parent = $('<div id="ned-notification-parent" class="ned-notification-background"></div>');
            $parent.hide();

            $parent.delegate('.ned-notification-close', 'click', function(e){
                e.preventDefault();
                let $target = $(e.target);
                let $elem = $target.closest($notes);
                elems_closed += 1;
                $elem.hide(animation_length,
                    () => elems_closed !== notes_html.length ? show_note($elem.next()) : $parent.hide()
                );

                return true;
            });

            $parent.keyup(function(e) {
                if (e.key === "Escape") {
                    $parent.find('.ned-notification-window:visible .ned-notification-close-window').click();
                }
            });

            $(document.body).prepend($parent);

            this.reset();
        },
        reset: function(){
            i_last = -1;
            notes_html = [];
            notes_ready = 0;
            note_calls = 0;
            elems_closed = 0;
            uniq_key = Date.now();
        },
        show: function(notifies, close_callback=null, click_callback=null){
            this.init();
            $parent.text('');
            if (!Array.isArray(notifies)){
                notifies = [notifies];
            }

            let i_start = i_last + 1;
            i_last += notifies.length;
            note_calls += 1;
            let extra_class = 'note_call_'+uniq_key+'_'+note_calls;

            if (close_callback){
                $parent.delegate('.'+extra_class+' .ned-notification-close', 'click', function(e){
                    let $target = $(e.target);
                    let $elem = $target.closest($notes);
                    close_callback($target, $elem);
                    return true;
                });
            }

            if (click_callback){
                $parent.delegate('.ned-notification-window.'+extra_class, 'click', function(e){
                    click_callback(e);
                    return true;
                });
            }

            for (let i=0; i < notifies.length; i++){
                let note = notifies[i];
                note.last = i === (notifies.length-1);
                note.extra_window_class = (note.extra_window_class ? (note.extra_window_class + ' ') : '') + extra_class;

                let Templ_render = function(note){
                    Templates.render('local_ned_controller/ned_notification', note).then(function(note_html){
                        notes_html[i_start+i] = $(note_html).hide();
                        notes_ready++;
                        if (notes_ready === i_last+1){
                            // Add notes & start show notifications
                            for (let i=0; i < notes_html.length; i++) {
                                $parent.append(notes_html[i]);
                            }
                            $parent.append('<div class="ned-notification-fix-position"></div>');
                            $notes = $parent.children('.ned-notification-window');
                            $parent.show(0, () => show_note($notes.eq(0)));
                        }
                    }).fail(function(ex) {
                        this.error_debug(`Failed to load ned_notification ${i}`, ex);
                    });
                }

                if (note.template && note.template_context){
                    Templates.render(note.template, note.template_context).then(function(note_body){
                        note.message = note_body;
                        Templ_render(note);
                    }).fail(function(ex) {
                        this.error_debug(`Failed to load body from template for notification ${i}`, ex);
                    });
                } else if (typeof note.message.then === 'function'){
                    $.when(note.message).done(function(val){
                            note.message = val;
                            Templ_render(note);
                    }).fail(function(ex) {
                        this.error_debug(`Failed to load promise body for notification ${i}`, ex);
                    });
                } else {
                    Templ_render(note);
                }

            }
        },
        show_one: function(notifies, close_callback=null, click_callback=null){
            this.reset();
            this.show(notifies, close_callback, click_callback);
        },
        debug: function(txt){
            log.debug('[show_ned_notify] ' + txt);
        },
        error_debug: function(txt, ex){
            let message = ex.message ? ex.message : ex.error;
            this.debug(`${txt}: \n${message}\n${ex.debuginfo}\n${ex.backtrace}`);
        },
        set_animation_length: function(value=0){
            animation_length = value || animation_length_def;
        },
        parser_notes_by_elemid: function(notes_id){
            let $notes_data = $('#' + notes_id);
            if (!$notes_data.length){
                this.debug(`Can't find data element with id "${notes_id}"`);
                return null;
            }

            let notes = null;
            try {
                notes = JSON.parse($notes_data.val());
            } catch(err){
                this.debug('Can\'t parse value form data element');
                return null;
            }

            if (!notes || !notes.length){
                this.debug('There are no notifications in data element');
                return null;
            }
            return notes;
        },
    };

    function show_note($elem, callback=undefined){
        $elem.show(animation_length, function(){
            $elem.find('.btn-default.ned-notification-close').trigger('focus');
            if (callback){
                callback(this);
            }
        })
    }
});
