<?php
/**
 * @package    local_ned_controller
 * @category   NED
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller;

defined('MOODLE_INTERNAL') || die();

/**
 * Trait base_get_set_by_get_method
 *
 * @package local_ned_controller
 */
trait base_get_set_by_get_method{
    /**
     * @param $name
     *
     * @return null|mixed
     */
    public function __get($name){
        $method = 'get_' . $name;
        if (method_exists($this, $method)){
            return $this->$method();
        }
        return null;
    }

    /**
     * @param $name
     *
     * @return bool
     */
    public function __isset($name){
        $method = 'get_' . $name;
        return method_exists($this, $method);
    }

    /**
     * @param $name
     * @param $value
     *
     * @return null
     */
    public function __set($name, $value){
        $method = 'get_' . $name;
        if (method_exists($this, $method) ||
            property_exists(__CLASS__, $name) ||
            property_exists(__CLASS__, '_'.$name)){
            return null;
        } else {
            $this->$name = $value;
            return $value;
        }
    }
}
