<?php
/**
 * The mod_assign submission remove grades event.
 *
 * @package    local_ned_controller
 * @subpackage event
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\event;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

/**
 * The mod_assign submission remove grades event class.
 *
 * @package    local_ned_controller
 */
class submission_remove_grades extends submission_changes_base {

    /**
     * Returns description of what happened.
     *
     * @return string
     */
    public function get_description() {
        return "The user with id '$this->userid' clear all grades from the submission '$this->objectid' for the user with " .
            "id '$this->relateduserid' for the assignment with course module id '$this->contextinstanceid'.";
    }

    /**
     * Return localised event name.
     *
     * @return string
     */
    public static function get_name() {
        return NED::str('eventsubmissiongradescleared');
    }
}
