<?php

/**
 * The mod_assign submission removed event.
 *
 * @package    local_ned_controller
 * @subpackage event
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\event;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

/**
 * The mod_assign submission removed event class.
 *
 * @package local_ned_controller
 */
class submission_removed extends submission_changes_base {

    /**
     * Returns localised general event name.
     *
     * @return string
     */
    public static function get_name() {
        return NED::str('eventsubmissionremoved');
    }

    /**
     * Returns non-localised description of what happened.
     *
     * @return string
     */
    public function get_description() {
        $action = $this->other['reset'] ? 'reset' : 'removed';
        $status = $this->other['submissionstatus'] ?? '?';
        $attempt = $this->other['submissionattempt'] ?? -1;
        $attempt = ($attempt+1) ?: '?';
        return "The user with id '$this->userid' $action the submission '$this->objectid' (attempt $attempt) with status '$status' ".
            "for the user with id '$this->relateduserid' for the assignment with course module id '$this->contextinstanceid'.";
    }

    /**
     * Create instance of event.
     *
     * @param \assign|\local_ned_controller\mod_assign\assign $assign
     * @param \stdClass                                       $submission
     * @param bool                                            $reset
     *
     * @return submission_remove_grades
     */
    public static function create_from_submission($assign, $submission, $reset=false) {
        $params = static::get_event_params($assign, $submission, $reset);
        return static::create_event_by_params($assign, $submission, $params);
    }

    /**
     * @param \assign|\local_ned_controller\mod_assign\assign $assign
     * @param \stdClass                                       $submission
     * @param bool                                            $reset
     *
     * @return array
     */
    public static function get_event_params($assign, $submission, $reset=false){
        $params = parent::get_event_params($assign, $submission);
        $params['other']['reset'] = (int)$reset;

        return $params;
    }

    /**
     * Custom validation.
     *
     * @return void
     * @throws \coding_exception
     */
    protected function validate_data() {
        parent::validate_data();

        if (!isset($this->other['reset'])) {
            throw new \coding_exception('The \'reset\' value must be set in other.');
        }
    }

}
