<?php

/**
 * @package    local_ned_controller
 * @subpackage marking_manager
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\marking_manager;

use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

/**
 * Class marking_manager_forum
 *
 * @package local_ned_controller\marking_manager
 * @noinspection PhpUnused
 */
class marking_manager_forum extends marking_manager_mod
{
    // TODO working deadlines for forums
    const HAVE_DEADLINES = false;
    const SQL_POSTS = 'COALESCE(p.posts, 0)';
    const SQL_USER_TIMEMODIFIED = 'p.timemodified';
    const SQL_SUBMIT_TIME = "IF(".self::SQL_POSTS." > 0, ".self::SQL_USER_TIMEMODIFIED.", 0)";
    /**
     * Only if Rating is off, and Whole forum grading is ON – we use Whole forum grading,
     *  otherwise we use Rating grading (as default grading method, {@see \mod_forum\grades\gradeitems::get_itemname_mapping_for_component()})
     *
     * @see \local_ned_controller\shared\grade_util::grade_get_gi_itemnumber()
     */
    const SQL_GI_ITEMNUMBER = "IF(COALESCE(f.assessed, 0) = 0 AND COALESCE(f.grade_forum, 0) <> 0, ".
        NED::GRADE_ITEMNUMBER_FORUM_WHOLE.", ".NED::GRADE_ITEMNUMBER_FORUM_RATING.")";

    const SQL_CHECK_FORUM_GRADE = '(COALESCE(f.assessed, 0) <> 0 OR COALESCE(f.grade_forum, 0) <> 0)';
    const SQL_SHOULDPASS = '(' . self::SQL_CHECK_FORUM_GRADE . ' AND ' . parent::SQL_SHOULDPASS . ')';
    const SQL_COMPLETED_SUCCESSFULLY =
        'IF('.self::SQL_SHOULDPASS.', (gi.gradepass > 0 AND '.self::SQL_RAWGRADE.' >= gi.gradepass), '.self::SQL_COMPLETE.')';
    const SQL_COMPLETED_GRADE_SUCCESSFULLY = self::SQL_COMPLETED_SUCCESSFULLY;
    const SQL_SHOULDCOMPLETE = 'cm.completion > 0';
    const SQL_FORUM_SHOW = '(' . self::SQL_SHOULDPASS . ' OR ' . self::SQL_SHOULDCOMPLETE . ')';
    const URL_MANUAL_GRADING = '/mod/forum/view.php';
    const SQL_GT_SHOULDPASS = self::SQL_SHOULDPASS;

    /**
     * Return type of mod (static::MOD_*), and it's name of main DB-table
     * @return string
     */
    public function get_mod_type(){
        return static::MOD_FORUM;
    }

    /**
     * Return condition by there name
     * @param string|array $name
     *
     * @return array|string
     */
    public function sql_get_condition_raw($name){
        if (!is_null($ans = parent::sql_get_condition_raw($name))){
            return $ans;
        }

        $sql_rawgrade = $this::SQL_RAWGRADE;
        $sql_posts = $this::SQL_POSTS;
        $sql_complete = $this::SQL_COMPLETE;
        $sql_check_grade = $this::SQL_CHECK_FORUM_GRADE;

        $sql_not_overridden = $this::SQL_NOT_OVERRIDDEN;
        $sql_graded_by_overridden = $this::SQL_GRADED_BY_OVERRIDDEN;
        $sql_ungraded_by_overridden = $this::SQL_UNGRADED_BY_OVERRIDDEN;
        switch($name){
            case static::ST_UNSUBMITTED:
                return "$sql_posts = 0";
            case static::ST_SUBMITTED:
                return "$sql_posts > 0";
            case static::ST_UNMARKED:
                return "($sql_check_grade AND $sql_posts > 0 AND $sql_rawgrade IS NULL AND $sql_not_overridden) OR $sql_ungraded_by_overridden".
                    $this->_add_filter_unmarked_cond();
            case static::ST_MARKED:
                return "(IF($sql_check_grade, $sql_rawgrade IS NOT NULL, $sql_complete) OR $sql_graded_by_overridden)".
                    $this->_add_filter_marked_cond();
            default:
                debugging("MM: Unknown condition '$name'");
                return NED::SQL_NONE_COND;
        }
    }

    /**
     * Return base FROM and JOIN statements
     *
     * @return array
     */
    public function sql_get_base_from_basis(){
        $from = [];
        $from []= "
        LEFT JOIN (
            SELECT fd.forum AS forumid, 
                fp.userid AS userid, 
                MIN(fp.modified) AS timemodified,
                SUM(fp.id IS NOT NULL) as posts
            FROM {forum_discussions} fd
            LEFT JOIN {forum_posts} fp 
                ON fp.discussion = fd.id
            WHERE fp.deleted = 0
            GROUP BY fp.userid, fd.forum
        ) p ON p.userid = u.id AND f.id = p.forumid
        ";
        return $from;
    }

    /**
     * Return base WHERE statements
     *
     * @return array
     */
    public function sql_get_base_where(){
        $where = parent::sql_get_base_where();
        $where[] = $this::SQL_FORUM_SHOW;
        return $where;
    }
}
