<?php
/**
 * @package    local_ned_controller
 * @category   marking_manager
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\marking_manager;


/**
 * Trait mm_data_common
 *
 * Some keys, which you can get from any MM data
 *
 * @package local_ned_controller\marking_manager
 */
trait mm_data_common {
    /**
     * Record cah have all, some or none of the MM_base::MM_ALL_STATUSES keys
     * If you choose MM_base::SUM, you will get (int) sum of activities by this status
     *  otherwise - (bool) match activity to this status or not
     *
     * Use MM_base::SUM and MM_base::ST_ALL to get all statuses with SUM
     *  or MM_base::GET_ST = [list of statuses or MM_base::ST_ALL for all] to get statuses without SUM
     *  (otherwise status keys without SUM are used as filters
     *
     * NOTE: You can't use MM_base::SUM and MM_base::BY_USER together
     *
     * @see \local_ned_controller\marking_manager\MM_base::MM_ALL_STATUSES
     */

    /** @see \local_ned_controller\marking_manager\MM_base::ST_MARKED */
    public $marked;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_UNMARKED */
    public $unmarked;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_SUBMITTED */
    public $submitted;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_UNSUBMITTED */
    public $unsubmitted;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_DRAFT */
    public $draft;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_REOPENED */
    public $reopened;

    /** @see \local_ned_controller\marking_manager\MM_base::ST_MISSED_DEADLINE */
    public $missed_deadline;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_UNMARKED_MISSED_DEADLINE */
    public $unmarked_missed_deadline;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_UNMARKED_DUE_12h */
    public $unmarked_due_12h;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_UNMARKED_DUE_24h */
    public $unmarked_due_24h;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_UNMARKED_DUE_IMPORTANT */
    public $unmarked_due_important;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_SUBMITTED_MISSED_DEADLINE */
    public $submitted_missed_deadline;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_UNSUBMITTED_MISSED_DEADLINE */
    public $unsubmitted_missed_deadline;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_WAITING_ZERO */
    public $waitingzero;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_ZERO_GRADE */
    public $zerograde;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_GRADE_LESS_50 */
    public $grade_less_50;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_GRADE_NOT */
    public $grade_not;
    /** @see \local_ned_controller\marking_manager\MM_base::ST_GM_POSSIBLE */
    public $gt_possible;

    // If MM_base::USE_KICA
    public $kica_activity; // if there is kica_grade_items record

    // If MM_base::USE_DEADLINE
    public $duedate;    // after this submission will be late
    public $cutoffdate; // after this submission impossible
    // If MM_base::USE_DEADLINE or MM_base::HAVE_DEADLINE - get deadline statuses
    /** @see \local_ned_controller\marking_manager\MM_base::DEADLINE_NOTSET */
    public $deadline_notset;
    /** @see \local_ned_controller\marking_manager\MM_base::DEADLINE_PAST */
    public $deadline_past;
    /** @see \local_ned_controller\marking_manager\MM_base::DEADLINE_UPCOMING */
    public $deadline_upcoming;

    /** @see \local_ned_controller\marking_manager\MM_base::COUNT_STATUS */
    /** @see \local_ned_controller\marking_manager\MM_base::COUNT_WAITING_ZERO */
    public $count_waitingzero;
    /** @see \local_ned_controller\marking_manager\MM_base::COUNT_DRAFT */
    public $count_draft;
    /** @see \local_ned_controller\marking_manager\MM_base::COUNT_MISSED_DEADLINE */
    public $count_missed_deadline;
    /** @see \local_ned_controller\marking_manager\MM_base::COUNT_UNMARKED_MISSED_DEADLINE */
    public $count_unmarked_missed_deadline;
}
