<?php
/**
 * @package    local_ned_controller
 * @subpackage shared
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @noinspection PhpUnused
 */

namespace local_ned_controller\shared;

defined('MOODLE_INTERNAL') || die();

/** @var \stdClass $CFG */
require_once($CFG->libdir.'/completionlib.php');

/**
 * Interface C
 *
 * @package local_ned_controller\shared
 *
 * Be careful with redeclaration constants from "C" in child classes,
 *  as it will create conflicts with other trait methods (which use "raw" constants from "C" file)
 */
interface C {
    // Plugins
    const CTRL = 'local_ned_controller';
    const KICA = 'local_kica';
    const SchM = 'local_schoolmanager';
    const AI = 'local_academic_integrity';
    const TT = 'block_ned_teacher_tools';
    const SM = 'block_ned_student_menu';
    const BCM = 'block_ned_custom_menu';
    const NB = 'theme_ned_boost';
    const NC = 'theme_ned_classic';
    const PROXY = 'assignsubmission_proxy';
    const CTSUBMISSION = 'assignsubmission_ctsubmission';
    const PROXY_LOCAL = 'local_proxy';
    const FORMAT_NED = 'format_ned';
    //---
    const REPORT_GHS = 'report_ghs';

    const TT_NAME = 'ned_teacher_tools';
    const SM_NAME = 'ned_student_menu';
    const PROXY_NAME = 'proxy';
    const CTSUBMISSION_NAME = 'ctsubmission';

    const PLUGIN_DIRS = [
        self::CTRL         => '/local/ned_controller',
        self::KICA         => '/local/kica',
        self::SchM         => '/local/schoolmanager',
        self::AI           => '/local/academic_integrity',
        self::TT           => '/blocks/ned_teacher_tools',
        self::SM           => '/blocks/ned_student_menu',
        self::BCM          => '/blocks/ned_custom_menu',
        self::PROXY        => '/mod/assign/submission/proxy',
        self::CTSUBMISSION => '/mod/assign/submission/ctsubmission',
        self::PROXY_LOCAL  => '/local/proxy',
        self::FORMAT_NED   => '/course/format/ned',
        self::NB           => '/theme/ned_boost',
        self::NC           => '/theme/ned_classic',
    ];

    const PLUGIN_LIBS = [
        self::CTRL =>           self::PLUGIN_DIRS[self::CTRL].'/lib.php',
        self::KICA =>           self::PLUGIN_DIRS[self::KICA].'/lib.php',
        self::SchM =>           self::PLUGIN_DIRS[self::SchM].'/lib.php',
        self::AI =>             self::PLUGIN_DIRS[self::AI].'/lib.php',
        self::TT =>             self::PLUGIN_DIRS[self::TT].'/lib.php',
        self::SM =>             self::PLUGIN_DIRS[self::SM].'/lib.php',
        self::PROXY =>          self::PLUGIN_DIRS[self::PROXY].'/lib.php',
        self::CTSUBMISSION =>   self::PLUGIN_DIRS[self::CTSUBMISSION].'/lib.php',
        self::PROXY_LOCAL =>    self::PLUGIN_DIRS[self::PROXY_LOCAL].'/lib.php',
    ];

    // system_name => simple (for assignment) name
    const PROXY_DEADLINE_PLUGINS = [
        // order is matter
        self::CTSUBMISSION => self::CTSUBMISSION_NAME,
        self::PROXY => self::PROXY_NAME,
    ];

    // Tables
    const TABLE_USER_INFO_FIELD = 'user_info_field';
    const TABLE_USER_INFO_DATA = 'user_info_data';

    // Capabilities
    const CAPABILITY_COURSE_GRADER = 'moodle/grade:viewall';
    const CAPABILITY_STUDENT = 'mod/assign:submit';

    // Config
    const CONFIG_ADMIN_ALERTS = 'admin_alerts';
    const CONFIG_MAX_EVENT_LOOP = 10;

    // Diff
    const SESSION_RETURN_URL = 'session_return_url';
    const NED_TIMEZONE = 'America/Toronto';

    // Deadlines
    const EXTENSION_DELAY = 4*DAYSECS;
    const CUTOFFDATE_DELAY = 10*DAYSECS;
    const SOFT_ZERO_DELAY = self::CUTOFFDATE_DELAY;
    const DEADLINE_PENALTY_GRACE_PERIOD = 5*MINSECS;

    const NOTIFY_INFO = \core\output\notification::NOTIFY_INFO;
    const NOTIFY_SUCCESS = \core\output\notification::NOTIFY_SUCCESS;
    const NOTIFY_WARNING = \core\output\notification::NOTIFY_WARNING;
    const NOTIFY_ERROR = \core\output\notification::NOTIFY_ERROR;

    const E_NONE = 0;       // nothing
    const E_NOTICE = 1;     // show moodle notice
    const E_WARNING = 2;    // show php warning
    const E_ERROR = 3;      // stop script execution

    // Mods
    const ASSIGN = 'assign';
    const QUIZ = 'quiz';
    const FORUM = 'forum';
    const JOURNAL = 'journal';
    const FEEDBACK = 'feedback';
    const H5PACTIVITY = 'h5pactivity';
    const ALL = 0;

    // for compatibility
    const MOD_ASSIGN = self::ASSIGN;
    const MOD_QUIZ = self::QUIZ;
    const MOD_FORUM = self::FORUM;
    const MOD_JOURNAL = self::JOURNAL;
    const MOD_FEEDBACK = self::FEEDBACK;
    const MOD_H5PACTIVITY = self::H5PACTIVITY;
    const MOD_ALL = self::ALL;

    const MOD_ASSIGN_KEY = 1;
    const MOD_QUIZ_KEY = 2;
    const MOD_FORUM_KEY = 3;
    const MOD_JOURNAL_KEY = 4;
    const MOD_FEEDBACK_KEY = 5;
    const MOD_HVP_KEY = 6;

    const MOD_TYPES = [
        self::MOD_ASSIGN_KEY => self::MOD_ASSIGN,
        self::MOD_QUIZ_KEY => self::MOD_QUIZ,
        self::MOD_FORUM_KEY => self::MOD_FORUM,
        self::MOD_JOURNAL_KEY => self::MOD_JOURNAL,
        self::MOD_FEEDBACK_KEY => self::MOD_FEEDBACK,
        self::MOD_HVP_KEY => self::MOD_H5PACTIVITY,
    ];
    const MOD_VALS = [
        self::MOD_ASSIGN => self::MOD_ASSIGN_KEY,
        self::MOD_QUIZ => self::MOD_QUIZ_KEY,
        self::MOD_FORUM => self::MOD_FORUM_KEY,
        self::MOD_JOURNAL => self::MOD_JOURNAL_KEY,
        self::MOD_FEEDBACK => self::MOD_FEEDBACK_KEY,
        self::MOD_H5PACTIVITY => self::MOD_HVP_KEY,
    ];

    /** grade_item.itemnumber, @see \core_grades\local\gradeitem\itemnumber_mapping::get_itemname_mapping_for_component() */
    const GRADE_ITEMNUMBER_USUAL = 0;
    /** @see \mod_forum\grades\gradeitems::get_itemname_mapping_for_component() */
    const GRADE_ITEMNUMBER_FORUM_RATING = 0;
    const GRADE_ITEMNUMBER_FORUM_WHOLE = 1;

    const MM_PAGE = self::PLUGIN_DIRS[self::TT].'/marking_manager.php';
    const CLASS_PROGRESS_PAGE = self::PLUGIN_DIRS[self::TT].'/progress_report.php';

    // KICA
    const KICA_K = 'knowledge';
    const KICA_I = 'inquiry';
    const KICA_C = 'communication';
    const KICA_A = 'application';
    const KICA_KEYS = [self::KICA_K, self::KICA_I, self::KICA_C, self::KICA_A];

    const FINALGRADE = 'finalgrade';
    const KICA_F = self::FINALGRADE;
    const KICAF_KEYS = [self::KICA_K, self::KICA_I, self::KICA_C, self::KICA_A, self::KICA_F];
    const FKICA_KEYS = [self::KICA_F, self::KICA_K, self::KICA_I, self::KICA_C, self::KICA_A];

    // TT&SM
    const SEC_IN_DAY = DAYSECS;

    const VIEW_USERS_SUSPENDED_NONE = 0;
    const VIEW_USERS_SUSPENDED_ENROLLMENTS = 1;
    const VIEW_USERS_SUSPENDED_ACCOUNTS = 2;
    const VIEW_USERS_SUSPENDED_BOTH = 3;

    // Functions constants
    const LOGIC_ANY = 0;
    const LOGIC_ALL = 1;
    const LOGIC_ANY_OR_ALL = [self::LOGIC_ANY, self::LOGIC_ALL];

    const COMPARE_MORE = 0;
    const COMPARE_LESS = 1;
    const COMPARE_ML_OPTIONS = [self::COMPARE_MORE, self::COMPARE_LESS];

    const CM_COMPLETIONS = [COMPLETION_INCOMPLETE, COMPLETION_COMPLETE, COMPLETION_COMPLETE_PASS, COMPLETION_COMPLETE_FAIL];

    // Roles
    const ROLE_SSA = 's-sa'; // System - School Administrator [SA]
    const ROLE_SDA = 's-da'; // System - District Admin [DA]
    const ROLE_RSA = 'r-sa'; // Course - School Administrator [SA]
    const ROLE_RDA = 'r-da'; // Course - District Admin [DA]
    const ROLE_SOT = 's-ot'; // System - Grading Teacher
    const ROLE_SCT = 's-ct'; // System - Classroom Teacher
    const ROLE_OT = 'online-teacher';
    const ROLE_CT = 'classroom-teacher';
    const ROLE_STUDENT = 'student';

    const FIELD_DEFAULT_ROLE = 'default_role';
    const DEFAULT_ROLE_STUDENT = 'Student';
    const DEFAULT_ROLE_SCHOOL_ADMINISTRATOR = 'School Administrator';
    const DEFAULT_ROLE_CT = 'Classroom Teacher';
    const DEFAULT_ROLE_OT = 'Online Teacher';
    const DEFAULT_ROLE_STAFF_ROLES = [
        self::DEFAULT_ROLE_CT, self::DEFAULT_ROLE_SCHOOL_ADMINISTRATOR, self::DEFAULT_ROLE_OT,
        'Classroom Assistant', 'Guidance Counsellor', 'District Administrator',
    ];

    // School
    const SCHOOL_CODE_LENGTH = 4;
    const SCHOOL_MISSING = '[Missing]';
    const SCHOOL_NONE = '[None]';
    const SCHOOL_EMPTY_LIST = [
        self::SCHOOL_NONE => self::SCHOOL_NONE,
        self::SCHOOL_MISSING => self::SCHOOL_MISSING,
    ];

    const GROUP_ALL = 0;
    const GROUP_NONE = -1;
    const GROUPS = [self::GROUP_ALL, self::GROUP_NONE];

    const TAG_MIDTERM = 'Midterm point';
    const TAG_FORMATIVE = 'Formative';
    const TAG_SUMMATIVE =  'Summative';
    const TAG_CTA = 'CTA Activity';
    const TAG_QUICK_FEEDBACK = 'Quick Feedback';
    const TAG_FINAL_EXAM =  'Final Exam';
    const TAG_FINAL_PROJECT =  'Final Project';
    const TAG_UNIT_TEST = 'Unit Test';
    const TAG_LAST_ACTIVITY = 'Last Activity';
    const TAG_PROXY = 'Proxy';
    const TAG_SLA3 = 'SLA-OT3';
    const TAG_SLA5 = 'SLA-OT5';
    const TAG_TERM1 = 'Term 1';
    const TAG_TERM2 = 'Term 2';

    const IMPORTANT_TAGS = [
        'midterm' => self::TAG_MIDTERM,
        'formative' => self::TAG_FORMATIVE,
        'summative' => self::TAG_SUMMATIVE,
    ];
    const TERMS = [
        self::TAG_TERM1 => 'term1',
        self::TAG_TERM2 => 'term2'
    ];
    const SLA_TAGS = [
        self::TAG_SLA3 => self::TAG_SLA3,
        self::TAG_SLA5 => self::TAG_SLA5,
    ];


    // Resubmissions
    const RESUBMISSIONS_ALL = 0;
    const RESUBMISSIONS_MADE_BY_RM = 10;
    const RESUBMISSIONS_MADE_BY_RM_CONTROLLED_NOT_BY_RM = 11;
    const RESUBMISSIONS_MADE_BY_RM_CONTROLLED_BY_RM = 12;
    const RESUBMISSIONS_MADE_NOT_BY_RM = 20;
    const RESUBMISSIONS_MADE_NOT_BY_RM_CONTROLLED_NOT_BY_RM = 21;
    const RESUBMISSIONS_MADE_NOT_BY_RM_CONTROLLED_BY_RM = 22;
    const RESUBMISSIONS_KEYS = [
        self::RESUBMISSIONS_ALL, self::RESUBMISSIONS_MADE_BY_RM,
        self::RESUBMISSIONS_MADE_BY_RM_CONTROLLED_NOT_BY_RM, self::RESUBMISSIONS_MADE_BY_RM_CONTROLLED_BY_RM,
        self::RESUBMISSIONS_MADE_NOT_BY_RM, self::RESUBMISSIONS_MADE_NOT_BY_RM_CONTROLLED_NOT_BY_RM,
        self::RESUBMISSIONS_MADE_NOT_BY_RM_CONTROLLED_BY_RM
    ];

    /**
     * NED Grade Statuses
     *  avoid spaces, as them used in CSS selectors
     */
    const STATUS_ALL = 'all';
    const STATUS_NONE = 'none';
    const STATUS_EXCLUDED = 'excluded';
    const STATUS_COMPLETED = 'completed';
    const STATUS_PASSED = 'passed'; // graded
    const STATUS_INCOMPLETED = 'incompleted';
    const STATUS_DRAFT = 'draft';
    const STATUS_NOTATTEMPTED = 'notattempted';
    const STATUS_WAITINGFORGRADE = 'waitingforgrade';
    const STATUS_GRADED_KICA = 'graded_kica';
    const STATUS_GRADED_KICA_SUMMATIVE = 'graded_kica_summative';
    const STATUS_GRADED_KICA_FORMATIVE = 'graded_kica_formative';
    const STATUS_UNGRADED_KICA = 'ungraded_kica';
    const STATUS_UNGRADED_KICA_SUMMATIVE = 'ungraded_kica_summative';
    const STATUS_UNGRADED_KICA_FORMATIVE = 'ungraded_kica_formative';
    const STATUS_INCOMPLETED_SUMMATIVE = 'incompleted_summative';
    const STATUS_INCOMPLETED_FORMATIVE = 'incompleted_formative';
    const STATUS_KICA_ZEROGRADE = 'kica_zerograde';
    // MM
    const STATUS_MARKED = 'marked';
    const STATUS_UNMARKED = 'unmarked'; // haven't grade, but need it
    const STATUS_SUBMITTED = 'submitted';
    const STATUS_UNSUBMITTED = 'unsubmitted';
    // other
    const STATUS_NGC_ZERO = 'ngc_zero';
    const STATUS_DEADLINE_PAST = 'deadline_past';
    const STATUS_RESUBMISSION = 'resubmission';
    const STATUS_SOFT_ZERO = 'soft_zero';
    const STATUS_HARD_ZERO = 'hard_zero';
    const STATUS_EXTENSION = 'can_award_extension';
    // Icons
    const ICON_TYPE_ZERO = 'type-zero';
    const ICON_TYPE_DEDUCTION = 'type-deduction';
    const ICON_REASON_AI = 'reason-ai';
    const ICON_REASON_FILE = 'reason-wrong';
    const ICON_REASON_MISSED = 'reason-missed';
    const ICON_REASON_OTHER = 'reason-other';
    const ICON_LETTER = 'letter';
    const ICON_URL_DATA = 'url_data'; // special
    const ICON_URL_AI_ID = 'ai_id'; // special
    // group statuses
    const ST_FORMATIVE = [self::STATUS_UNGRADED_KICA_FORMATIVE, self::STATUS_GRADED_KICA_FORMATIVE, self::STATUS_INCOMPLETED_FORMATIVE];
    const ST_SUMMATIVE = [self::STATUS_UNGRADED_KICA_SUMMATIVE, self::STATUS_GRADED_KICA_SUMMATIVE, self::STATUS_INCOMPLETED_SUMMATIVE];
    const ST_GENERAL = [self::STATUS_DRAFT, self::STATUS_DEADLINE_PAST,
        self::STATUS_RESUBMISSION, self::STATUS_EXTENSION, self::STATUS_KICA_ZEROGRADE];
    const ST_NOT_KICA = [self::STATUS_WAITINGFORGRADE, self::STATUS_COMPLETED, self::STATUS_INCOMPLETED];
    const ST_ZEROS = [self::STATUS_SOFT_ZERO, self::STATUS_HARD_ZERO];

    // Conditions
    const COND_KEY_EQ   = 'eq';
    const COND_KEY_NEQ  = 'neq';
    const COND_KEY_GT   = 'gt';
    const COND_KEY_GTE  = 'gte';
    const COND_KEY_LT   = 'lt';
    const COND_KEY_LTE  = 'lte';

    const COND_EQ   = '==';
    const COND_NEQ  = '!=';
    const COND_GT   = '>';
    const COND_GTE  = '>=';
    const COND_LT   = '<';
    const COND_LTE  = '<=';

    const CONDITIONS = [
        self::COND_KEY_EQ  => self::COND_EQ,
        self::COND_KEY_NEQ => self::COND_NEQ,
        self::COND_KEY_GT  => self::COND_GT,
        self::COND_KEY_GTE => self::COND_GTE,
        self::COND_KEY_LT  => self::COND_LT,
        self::COND_KEY_LTE => self::COND_LTE,
    ];
    const CONDITION_KEYS = [
        self::COND_EQ  => self::COND_KEY_EQ,
        self::COND_NEQ => self::COND_KEY_NEQ,
        self::COND_GT  => self::COND_KEY_GT,
        self::COND_GTE => self::COND_KEY_GTE,
        self::COND_LT  => self::COND_KEY_LT,
        self::COND_LTE => self::COND_KEY_LTE,
    ];

    // SQL
    const SQL_NOW = "UNIX_TIMESTAMP()";
    const SQL_NOW_12h = "UNIX_TIMESTAMP(TIMESTAMPADD(HOUR, 12, CURRENT_TIMESTAMP))";
    const SQL_NOW_24h = 'UNIX_TIMESTAMP(TIMESTAMPADD(HOUR, 24, CURRENT_TIMESTAMP))';
    const SQL_LAST_1h = "UNIX_TIMESTAMP(TIMESTAMPADD(HOUR, -1, CURRENT_TIMESTAMP))";
    const SQL_NONE_COND = '0<>0';
    const SQL_TRUE_COND = '1=1';

    // SQL Conditions
    const SQL_COND_EQ   = "=";
    const SQL_COND_NEQ  = "<>";
    const SQL_COND_GT   = ">";
    const SQL_COND_GTE  = ">=";
    const SQL_COND_LT   = "<";
    const SQL_COND_LTE  = "<=";

    const SQL_CONDITIONS = [
        self::COND_KEY_EQ  => self::SQL_COND_EQ,
        self::COND_KEY_NEQ => self::SQL_COND_NEQ,
        self::COND_KEY_GT  => self::SQL_COND_GT,
        self::COND_KEY_GTE => self::SQL_COND_GTE,
        self::COND_KEY_LT  => self::SQL_COND_LT,
        self::COND_KEY_LTE => self::SQL_COND_LTE,
    ];
    const SQL_CONDITION_KEYS = [
        self::SQL_COND_EQ  => self::COND_KEY_EQ,
        self::SQL_COND_NEQ => self::COND_KEY_NEQ,
        self::SQL_COND_GT  => self::COND_KEY_GT,
        self::SQL_COND_GTE => self::COND_KEY_GTE,
        self::SQL_COND_LT  => self::COND_KEY_LT,
        self::SQL_COND_LTE => self::COND_KEY_LTE,
    ];

    // HTML
    const HTML_INVISIBLE = '&#8205;';
    const HTML_SPACE = '&nbsp;';

    // Some usual page params
    const PAR_ID = 'id';
    const PAR_IDS = 'ids';
    const PAR_FILTER_ID = 'filterid';
    const PAR_FILTER_IDS = 'filterids';
    const PAR_COURSE = 'course';
    const PAR_COURSE_VIEW = 'course_view';
    const PAR_CM = 'cm';
    const PAR_USER = 'user';
    const PAR_GROUP = 'group';
    const PAR_STATUS = 'status';
    const PAR_GRADER = 'grader';
    const PAR_SCHOOL = 'school';
    const PAR_ACTION = 'action';
    const PAR_ACTIVE = 'active';
    const PAR_DOWNLOAD = 'download';
    const PAR_PAGE = 'page';
    const PAR_PERPAGE = 'perpage';
    const PAR_SETUSER = 'setuser';
    const PAR_STEP = 'step';
    const PAR_NOTE = 'note';
    const PAR_SCHOOL_YEAR = 'sy';
    const PAR_CONFIRM = 'confirm';
    const PAR_RETURN_URL = 'returnurl';
    const PAR_SESSKEY = 'sesskey';
    const PAR_VIEW = 'view';
    const PAR_SORT = 'sort';
    const PAR_SORT_DESC = 'desc';
    const PAR_DIR = 'dir';
    const PAR_DM_TO_MISSED = 'dmmissed';
    const PAR_PROFILE_SCHOOL_YEAR = self::CTRL.'_'.self::PAR_SCHOOL_YEAR;
    const PAR_USE_KICA_QUIZ = 'ukq';

    // Default type - PARAM_INT, default 'default' - 0
    const PARAM_DATA = [
        self::PAR_IDS         => ['type' => PARAM_TEXT, 'default' => null],
        self::PAR_FILTER_IDS  => ['type' => PARAM_TEXT, 'default' => null],
        self::PAR_COURSE_VIEW => ['type' => PARAM_BOOL, 'default' => null], // default is _DEFAULT_COURSE_VIEW
        self::PAR_SORT        => ['type' => PARAM_INT, 'default' => null],
        self::PAR_SORT_DESC   => ['type' => PARAM_BOOL, 'default' => null],
        self::PAR_DOWNLOAD    => ['type' => PARAM_ALPHA, 'default' => null],
        self::PAR_SCHOOL_YEAR => ['type' => PARAM_INT, 'default' => null],
        self::PAR_USE_KICA_QUIZ => ['type' => PARAM_BOOL, 'default' => null],
    ];

    const SORT_ASC = false;
    const SORT_DESC = true;

    const PERPAGE_ALL = 'all';
    const PERPAGES = [100, 250, 500, 1000, 5000, 10000, self::PERPAGE_ALL];

    // Pages
    const PAGE_MOODLE_LOGIN     = '/login/index.php';
    const PAGE_MOODLE_LOGOUT    = '/login/logout.php';
    const PAGE_MOODLE_LOGINAS   = '/course/loginas.php';
    const PAGES_MOODLE_LOGIN = [
        self::PAGE_MOODLE_LOGIN   => self::PAGE_MOODLE_LOGIN,
        self::PAGE_MOODLE_LOGOUT  => self::PAGE_MOODLE_LOGOUT,
        self::PAGE_MOODLE_LOGINAS => self::PAGE_MOODLE_LOGINAS,
    ];

    const PAGE_MOODLE_FILE_DOWNLOAD = '/pluginfile.php';

    const PAGE_COURSE = '/course/view.php';

    // quiz pages, where student can be in the process of work
    const PAGE_QUIZ_ATTEMPT = '/mod/quiz/attempt.php';
    const PAGE_QUIZ_SUMMARY = '/mod/quiz/summary.php';
    const PAGE_QUIZ_PROCESS = '/mod/quiz/processattempt.php';

    const PAGE_NED_CONTROLLER = '/local/ned_controller/index.php';
    const PAGE_GRADE_CONTROLLER = '/local/ned_controller/grade_controller.php';

    const PAGE_MM = '/blocks/ned_teacher_tools/marking_manager.php';
    const PAGE_SP = '/blocks/ned_teacher_tools/student_progress.php';
    const PAGE_CP = '/blocks/ned_teacher_tools/progress_report.php';
    const PAGE_KICA = '/local/kica/grade_user.php';
    const PAGE_GB = '/grade/report/grader/index.php';
    const PAGE_DM = '/blocks/ned_teacher_tools/deadline_manager.php';

    const PAGE_DM_EDIT = '/blocks/ned_teacher_tools/deadline_manager_edit.php';
    const PAGE_KICA_SETTINGS = '/local/kica/coursesettings.php';
    const PAGE_KICA_ACTIVITIES = '/local/kica/kicaactivities.php';
    const PAGE_KICA_ACTIVITIES_EDIT = '/local/kica/kicaactivities_edit.php';
    const PAGE_KICA_GRADE_ACTIVITY = '/local/kica/grade_activity.php';
    const PAGE_KICA_GRADE_USER = self::PAGE_KICA;
    const PAGE_KICA_NOTIFICATIONS = '/local/kica/notifications.php';
    const PAGE_KICA_ZEROGRADES = '/local/kica/zerogrades.php';

    const PAGE_KICA_QUIZGRADING = '/local/kicaquizgrading/view.php';

    const PAGE_AI_INFRACTIONS = '/local/academic_integrity/infractions.php';
    const PAGE_AI_ADD_INFRACTION = '/local/academic_integrity/infraction.php';
    const PAGE_AI_VIEW = '/local/academic_integrity/infraction_view.php';

    const PAGE_COPYLEAKS_REPORT = '/plagiarism/copyleaks/plagiarism_copyleaks_report.php';
    const PAGE_COPYLEAKS_DOWNLOAD = '/plagiarism/copyleaks/plagiarism_copyleaks_download_report_pdf.php';

    // Date Time
    const DT_FORMAT_DATE= '%d %b %Y';
    const DT_FORMAT_DATE_MDY= '%m/%d/%Y';
    const DT_FORMAT_TIME12 = '%l:%M%p'; // '%I:%M %p'
    const DT_FORMAT_TIME24 = '%H:%M';
    const DT_FORMAT_FULL = self::DT_FORMAT_DATE.' @ '.self::DT_FORMAT_TIME12;

    /**
     * Controller caches
     * @see /local/ned_controller/db/caches.php
     */
    // Application caches
    const CACHE_SHARED = 'shared_cache';
    const CACHE_SHARED_KEY_FE_COMPLETION = 'fe_completion_';

    const CACHE_NOTIFICATION = 'notification';

    // Session caches
    const CACHE_USERS = 'users';
    const CACHE_USERS_KEY_CHECK_DRAFT = 'check_draft';
    const CACHE_USERS_KEY_LAST_DRAFT = 'last_draft';
    const CACHE_USERS_KEY_ASSIGN_CLOSE = 'assign_close_';
    const CACHE_USERS_KEY_CTA_COURSE_CHECK = 'cta_course_check_';

}
