<?php
/**
 * @package    local_ned_controller
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller;

defined('MOODLE_INTERNAL') || die();

/**
 * Class stdClass2
 * As stdClass, but return null when try to read an unset property
 *
 * @package local_ned_controller
 */
class stdClass2 extends \stdClass{

    /**
     * stdClass2 constructor.
     *
     * @param array|object $data
     */
    public function __construct($data=[]){
        $object = (object)$data;
        foreach ($object as $prop => $value){
            $this->$prop = $value;
        }
    }

    /**
     * @param string $name
     *
     * @return mixed|null
     */
    public function __get($name){
        return $this->$name ?? null;
    }

    /**
     * @param string $name
     * @param mixed  $value
     *
     * @return mixed
     */
    public function __set($name, $value){
        $this->$name = $value;
        return $value;
    }
}