<?php
/**
 * @package    local_ned_controller
 * @subpackage support
 * @category   NED
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\support;

defined('MOODLE_INTERNAL') || die();

/**
 * Class scale
 *
 * @package local_ned_controller\support
 */
class ned_proxy_record {
    use \local_ned_controller\base_empty_class;
    /** @var int $cmid - course-module id of proxy activity */
    public $cmid;
    /** @var string $plugin - name of proxy plugin, ie 'proxy' */
    public $plugin;
    /** @var int $submissionwindow - time in secs for proxy deadline after point activity deadline */
    public $submissionwindow;
    /** @var int $point_activity - course-module id of proxy-point activity */
    public $point_activity;

    /**
     * ned_proxy_record constructor.
     *
     * @param        $record
     * @param string $prefix
     */
    public function __construct($record, $prefix=''){
        $this->import($record, true, null, $prefix);
    }
}
