<?php
/**
 * @package    local_ned_controller
 * @subpackage support
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\support;

defined('MOODLE_INTERNAL') || die();

/**
 * Class submission_info
 * Need for the class assign_info
 *
 * @package local_ned_controller\support
 *
 * @property-read $id;
 * @property-read $assign;
 * @property-read $status;
 * @property-read $submit_time;
 * @property-read $submission_number;
 * @property-read $submission_latest;
 * @property-read $grade_time;
 * @property-read $grade;
 *
 * @property-read $userid;
 * @property-read $courseid;
 * @property-read $authorization;
 *
 * @property-read $submitted = false;
 * @property-read $requiregrading = false;
 * @property-read $graded = false;
 * @property-read $draft = false;
 * @property-read $user_sign = false;
 */
class submission_info{
    use \local_ned_controller\base_empty_class;

    private $_id;
    private $_assign;
    private $_status;
    private $_submit_time;
    private $_submission_number;
    private $_submission_latest;
    private $_grade_time;
    private $_grade;

    private $_userid;
    private $_courseid;
    private $_authorization;

    private $_submitted = false;
    private $_requiregrading = false;
    private $_graded = false;
    private $_draft = false;
    private $_user_sign = false;

    public function __construct(\stdClass $record){
        $this->copy($record, '_');
        $this->_id = $record->submission;

        if (!empty($this->_submit_time) && $this->_status == ASSIGN_SUBMISSION_STATUS_SUBMITTED) {
            $this->_submitted = true;
        }

        if (!empty($this->_grade_time) && !is_null($this->_grade) && $this->_grade >= 0){
            $this->_graded = true;
        } elseif ($this->_submitted){
            $this->_requiregrading = true;
        }

        $this->_draft = $this->_status == 'draft';
        $this->_user_sign = $this->_userid == $this->_authorization;
    }
}
