<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    local_ned_controller
 * @subpackage NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\task;

use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die;
require_once(__DIR__. '/../../lib.php');

/**
 * Class adhoc_cron_ngc_fixed_submissions
 *
 * @package local_ned_controller\task
 */
class adhoc_cron_ngc_fixed_submissions extends adhoc_base_cron_ned_grade_controller {
    use base_task;

    protected $_blocking = false;
    protected $_concurrency_limit = null;

    /**
     * If return false, task will not execute
     *
     * @return bool
     */
    public function can_execute(){
        if (!parent::can_execute()){
            return false;
        }

        $config = NED::get_config();
        if (!$config->cron_ngc_fixed_submissions_enable){
            static::print('adhoc_cron_ngc_fixed_submissions is not enable, pass.');
            return false;
        }

        return true;
    }

    /**
     * Do task job without any checks
     *
     * @param array|object|adhoc_base_cron_ned_grade_controller|null $task_or_data
     *
     * @return void
     */
    static public function do_job($task_or_data=[]){
        parent::do_job($task_or_data);
    }

    /**
     * Return count of added or changed records
     *
     * @param numeric $courseid
     *
     * @return int
     */
    static public function do_course_job($courseid){
        return NED::$ned_grade_controller::check_fixed_submissions_by_course($courseid);
    }
}
