<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Clear deleted users
 *
 * @package    local_ned_controller
 * @subpackage task
 * @category   NED
 * @copyright  2023 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\task;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();
NED::require_file('~/lib.php');

/**
 * Class clear_deleted_users
 *
 * @package local_ned_controller\task
 */
class clear_deleted_users extends \core\task\scheduled_task {
    use base_task;

    /**
     * Get a descriptive name for this task (shown to admins).
     *
     * @return string
     */
    static public function get_task_name() {
        return NED::str('cleardeletedusers');
    }

    /**
     * Do task job without any checks
     *
     * @param base_task|array|null $task_or_data
     *
     * @return void
     * @noinspection PhpUnnecessaryCurlyVarSyntaxInspection
     */
    static public function do_job($task_or_data=[]){
        //static::get_data_from_task_or_data($task_or_data);

        // table name => user field
        $check_tables = [
            'local_ned_controller_grades' => 'userid',
            'local_academic_integrity_inf' => 'student',
        ];

        $db_tables = NED::db()->get_tables();
        foreach ($check_tables as $table => $user_field){
            if (!isset($db_tables[$table])) continue;

            static::print("Clear '$table' table");
            $sql = "
                DELETE t
                FROM {{$table}} t
                LEFT JOIN {user} u
                    ON u.id = t.$user_field
                    AND u.deleted = 0
                WHERE u.id IS NULL
            ";
            NED::db()->execute($sql);
        }
    }
}
