<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Enable group conversation.
 *
 * @package     local_ned_controller
 * @category    task
 * @copyright   2022 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\task;

defined('MOODLE_INTERNAL') || die();

global $CFG;
require_once($CFG->dirroot.'/group/lib.php');

/**
 * Class enable_group_conversation
 *
 * @package enable_group_conversation\task
 */
class enable_group_conversation extends \core\task\scheduled_task {

    /**
     * Get a descriptive name for this task (shown to admins).
     *
     * @return string
     */
    public function get_name() {
        return get_string('enablegroupconversation', 'local_ned_controller');
    }

    /**
     * Do the job.
     * Throw exceptions on errors (the job will be retried).
     */
    public function execute() {
        global $DB;

        $sql = "SELECT g.id, g.courseid, g.idnumber, g.name, mc.id conversationid, COALESCE(mc.enabled, 2) enabled
                  FROM {groups} g
             LEFT JOIN {message_conversations} mc
                    ON g.id = mc.itemid
                   AND mc.component = 'core_group'
                   AND mc.itemtype = 'groups' 
	             WHERE mc.enabled = 0 OR mc.enabled IS NULL";

        $rs = $DB->get_recordset_sql($sql);

        foreach ($rs AS $group) {
            if ($group->enabled == 0) {
                \core_message\api::enable_conversation($group->conversationid);
            } else {
                $context = \context_course::instance($group->courseid);
                $conversation = \core_message\api::create_conversation(
                    \core_message\api::MESSAGE_CONVERSATION_TYPE_GROUP,
                    [],
                    $group->name,
                    \core_message\api::MESSAGE_CONVERSATION_ENABLED,
                    'core_group',
                    'groups',
                    $group->id,
                    $context->id
                );

                // Add members to conversation if they exist in the group.
                if ($groupmemberroles = groups_get_members_by_role($group->id, $group->courseid, 'u.id')) {
                    $users = [];
                    foreach ($groupmemberroles as $roleid => $roledata) {
                        foreach ($roledata->users as $member) {
                            $users[] = $member->id;
                        }
                    }
                    \core_message\api::add_members_to_conversation($users, $conversation->id);
                }
            }
        }

        $rs->close();
    }
}