<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Update Plugin Info.
 *
 * @package     local_ned_controller
 * @category    task
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\task;

defined('MOODLE_INTERNAL') || die();

/**
 * Class update_plugin_info
 *
 * @package local_ned_controller\task
 */
class update_user_institution extends \core\task\scheduled_task {

    /**
     * Get a descriptive name for this task (shown to admins).
     *
     * @return string
     */
    public function get_name() {
        return get_string('updateuserinstitutionwithprofilefield', 'local_ned_controller');
    }

    /**
     * Do the job.
     * Throw exceptions on errors (the job will be retried).
     */
    public function execute() {
        global $DB;

        $sql = "SELECT d.id, d.userid, d.data
                  FROM {user_info_field} f
	              JOIN {user_info_data} d
                    ON f.id = d.fieldid
                  JOIN {user} u 
                    ON d.userid = u.id
                 WHERE f.shortname = 'partner_school'
                   AND d.data <> ''
                   AND u.deleted = 0";

        $rs = $DB->get_recordset_sql($sql);

        foreach ($rs AS $profile) {
            $user = new \stdClass();
            $user->id = $profile->userid;
            $user->institution = $profile->data;
            $DB->update_record('user', $user);
        }

        $rs->close();
    }
}