<?php
/**
 * Plugins overview
 *
 * @package     local_ned_controller
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
/** @noinspection PhpUnusedLocalVariableInspection */

$definitions = [
    /**
     * Shared application cache for different purpose
     * @see \local_ned_controller\shared\C::CACHE_SHARED
     * keys:
     *  • courseid.'_'.$userid =>
     *      {@see \local_ned_controller\shared\grade_util::is_course_final_evaluation_completed()}
     */
    'shared_cache' => [
        'mode' => cache_store::MODE_APPLICATION,
        'simplekeys' => true
    ],

    /**
     * @see \local_ned_controller\shared\C::CACHE_NOTIFICATION
     * for /local/ned_controller/classes/ned_notifications.php - don't use it in other places
     */
    'notification' => [
        'mode' => cache_store::MODE_APPLICATION,
        'simplekeys' => true
    ],

    /**
     * Session cache
     * @see \local_ned_controller\shared\C::CACHE_USERS
     * + key 'user_notes' used in /local/ned_controller/classes/ned_notifications.php
     * + key 'user_deadline_notes' used in /local/ned_controller/classes/deadline_notification.php
     *
     * you can use other keys of this cache, if you wish
     */
    'users' => [
        'mode' => cache_store::MODE_SESSION,
        'simplekeys' => true
    ],
];
