<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Install.
 *
 * @package     local_ned_controller
 * @category    install
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

function xmldb_local_ned_controller_install() {
    global $DB;

    // Initial plugins.
    $plugins = [
        'moodle-block_ned_teacher_tools' => ['NED Teacher Tools', 'block'],
        'moodle-block_ned_student_menu' => ['NED Student Menu', 'block'],
        'moodle-block_mentor' => ['NED Mentor Manager', 'block'],
        'moodle-block_custom_menu' => ['NED Custom Menu', 'block'],
        'moodle-mod_nedactivitycluster' => ['NED Activity Cluster', 'mod'],
        'moodle-format_ned' => ['NED Format', 'format'],
        'moodle-theme_ned_boost' => ['NED Boost', 'theme'],
        'moodle-theme_ned_clean' => ['NED Clean', 'theme'],
        'moodle-filter_ned' => ['NED Filter', 'filter'],
        'moodle-local_ned_controller' => ['NED Controller', 'local']
    ];

    foreach ($plugins as $repository => $plugin) {
        $rec = new stdClass();
        $rec->name = $plugin[0];
        $rec->repository = $repository;
        $rec->plugintype = $plugin[1];
        $rec->timecreated = time();
        $DB->insert_record('local_ned_controller', $rec);
    }

    return true;
}