<?php
/**
 * Plugins overview
 *
 * @package     local_ned_controller
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
/** @noinspection PhpUnusedLocalVariableInspection */

$services = [
    'ned_notification' => [
        'functions' => ['local_ned_controller_update_user_notifications'],
        'requiredcapability' => '',
        'restrictedusers' => 0,
        'enabled'=> 1,
    ],
    'preview_ned_notification' => [
        'functions' => ['local_ned_controller_preview_ned_notification'],
        'requiredcapability' => '',
        'restrictedusers' => 0,
        'enabled'=> 1,
    ],
    'deadline_notification' => [
        'functions' => ['local_ned_controller_update_deadline_notification'],
        'requiredcapability' => '',
        'restrictedusers' => 0,
        'enabled'=> 1,
    ],
    'ned_badge_revoke' => [
        'functions' => ['local_ned_controller_badge_revoke'],
        'requiredcapability' => '',
        'restrictedusers' => 0,
        'enabled'=> 1,
    ],
];

$functions = [
    'local_ned_controller_update_user_notifications' => [
        'classname'   => 'local_ned_controller_external',
        'methodname'  => 'update_user_notifications',
        'classpath'   => 'local/ned_controller/externallib.php',
        'description' => 'Update user notifications',
        'type'        => 'write',
        'ajax' => true,
    ],
    'local_ned_controller_preview_ned_notification' => [
        'classname'   => 'local_ned_controller_external',
        'methodname'  => 'preview_ned_notification',
        'classpath'   => 'local/ned_controller/externallib.php',
        'description' => 'Get preview of notification',
        'type'        => 'read',
        'ajax' => true,
    ],
    'local_ned_controller_update_deadline_notification' => [
        'classname'   => 'local_ned_controller_external',
        'methodname'  => 'update_deadline_notification',
        'classpath'   => 'local/ned_controller/externallib.php',
        'description' => 'Update user deadline notification',
        'type'        => 'write',
        'ajax' => true,
    ],
    'local_ned_controller_badge_revoke' => [
        'classname'   => 'local_ned_controller_external',
        'methodname'  => 'badge_revoke',
        'classpath'   => 'local/ned_controller/externallib.php',
        'description' => 'Revoke user badge',
        'type'        => 'write',
        'ajax' => true,
    ],
    'local_ned_controller_ngc_info' => [
        'classname'   => 'local_ned_controller_external',
        'methodname'  => 'ngc_info',
        'classpath'   => 'local/ned_controller/externallib.php',
        'description' => 'Get NGC record info',
        'type'        => 'read',
        'ajax' => true,
    ],
];
