<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Upgrade.
 *
 * @package    local_ned_controller
 * @subpackage NED
 * @copyright  2018 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use \local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

require_once(__DIR__ . '/upgradelib.php');

function xmldb_local_ned_controller_upgrade($oldversion) {
    global $DB;
    $dbman = $DB->get_manager();

    if ($oldversion < 2024072200){
        local_ned_controller_moodle3_upgrades($oldversion);
    }

    if ($oldversion < 2024072400){
        // Remove data of the deleted "availability_othercompleted" plugin
        $pluginman = core_plugin_manager::instance();
        $pluginfo = $pluginman->get_plugin_info('availability_othercompleted');
        if ($pluginfo){
            if (!file_exists(NED::$DIRROOT.'/availability/condition/othercompleted/version.php')){
                $progress = new progress_trace_buffer(new text_progress_trace(), false);
                $pluginman->uninstall_plugin($pluginfo->component, $progress);
                $progress->finished();
            }
        }
    }

    return true;
}
