<?php

define('NO_OUTPUT_BUFFERING', true);

use \local_ned_controller\shared_lib as NED;

require(__DIR__ . '/../../config.php');

defined('MOODLE_INTERNAL') || die();

$PARAM_THREAD = '_thread';
$PARAM_DB = '_db';
$PARAM_N = 'n';
$PARAM_STEP = 'step';
$PARAM_SMAX = 's';
$PARAM_ORIG_ONLY = 'alone';
$PARAM_DEBUG = 'debug';

$DB_ORIG = 0;
$DB_CUSTOM = 1;

$action = optional_param(NED::PAR_ACTION, false, PARAM_BOOL);
$debug_on = optional_param($PARAM_DEBUG, false, PARAM_BOOL);
$N = optional_param($PARAM_N, 1000, PARAM_INT);
$S_step = optional_param($PARAM_STEP, 2, PARAM_INT);
$S_MAX = optional_param($PARAM_SMAX, 16, PARAM_INT);

$thread = optional_param($PARAM_THREAD, 0, PARAM_INT);
$change_db = optional_param($PARAM_DB, $DB_ORIG, PARAM_INT);
$orig_only = optional_param($PARAM_ORIG_ONLY, false, PARAM_BOOL);

$T = 'config_plugins';
$test_name = NED::CTRL.'_db_test_';
$data_name = NED::CTRL.'_db_data_';
$select_cond = "name LIKE :name AND plugin = :plugin";
$S_MIN = 2;

if ($action && $thread){
    set_time_limit(HOURSECS);

    $t = 0;
    $t_start = function() use (&$t){
        $t = hrtime(true);
    };
    $t_end = function($t_new=null) use (&$t){
        $t_new = $t_new ?? hrtime(true);
        return $t_new - $t;
    };
    $write = (bool)($thread % 2);
    $val = new stdClass();
    $val->thread = $thread;
    $val->write = (int)$write;
    try {
        if ($change_db == $DB_CUSTOM){
            // Open second connection.
            $bd_cfg = $DB->export_dbconfig();
            if (!isset($bd_cfg->dboptions)) {
                $bd_cfg->dboptions = array();
            }
            // set DB2 without slave
            unset($bd_cfg->dboptions['readonly']);
            $db = moodle_database::get_driver_instance($bd_cfg->dbtype, $bd_cfg->dblibrary);
            $db->connect($bd_cfg->dbhost, $bd_cfg->dbuser, $bd_cfg->dbpass, $bd_cfg->dbname, $bd_cfg->prefix, $bd_cfg->dboptions);
        } else {
            $db = $DB;
        }

        $test_params = ['plugin' => NED::CTRL, 'name' => $test_name.'%'];
        $t_start();
        $c = 0;
        for ($i=0; $i < $N; $i++){
            $records = $db->get_records_select($T, $select_cond, $test_params, '', '*', $i, 1);
            if (empty($records)) break;

            if ($write){
                foreach ($records as $record){
                    $record->value++;
                    $db->update_record($T, $record, true);
                }
            }

            $c += count($records);
            unset($records);
        }
        $res = $t_end();
        $val->res = $res;
        $val->records = $c;
    } catch (Exception $e){
        $info = get_exception_info($e);
        list($message, $moreinfourl, $link, $backtrace, $debuginfo, $errorcode) =
            [$info->message, $info->moreinfourl, $info->link, $info->backtrace, $info->debuginfo, $info->errorcode];
        NED::ediv("Error in the $thread thread:", 'error');
        NED::ediv($message, 'alert alert-danger');
        $val->error = $message;
    }

    $data = (object)['plugin' => NED::CTRL, 'name' => $data_name.'_'.$thread, 'value' => json_encode($val)];
    $DB->insert_record($T, $data);

    die;
}

//region Page prepare
$context = NED::ctx();
require_login();
require_capability('moodle/site:config', $context);

$url = NED::url('~/db_benchmark.php');
$PAGE->set_context($context);
$PAGE->set_url($url);
$PAGE->set_pagelayout('admin');
$title = NED::str('db_benchmark');
$PAGE->set_title($title);
$PAGE->set_heading($title);
$PAGE->navbar->add(NED::str('pluginname'), NED::url('~/index.php'));
$PAGE->navbar->add($title, $url);

echo $OUTPUT->header();
//endregion
//region Functions
$fa = function($val=null, $ignore_null=false){
    if (!$ignore_null && is_null($val)) return NED::fa('fa-question-circle-o');
    return NED::fa($val ? 'fa-check-square-o green' : 'fa-window-close-o error');
};
$count_bonus = function($original_val, $other_val){
    if (is_null($original_val) || is_null($other_val)) return '-';
    if (empty($original_val)) return empty($other_val) ? '0' : '∞';

    $bonus = ($other_val/$original_val * 100) - 100;
    if (abs($bonus) < 1){
        return '≈0%';
    } else {
        $sign = $bonus > 0 ? '-' : '+'; //inverted
        return $sign.round(abs($bonus), 1).'%';
    }

};
//endregion
// common part
$T1 = NED::hrtime();
/**
 * @see \moodle_read_slave_trait
 */
$have_slave = $DB->want_read_slave();
$slave_connect = $have_slave && $DB->perf_get_reads_slave();
$one_db_use = $orig_only || !$slave_connect;
$slave_info = [];
$slave_info[] = NED::div([NED::str('sitehasreplica'), ': ', $fa($have_slave, true)]);
if ($have_slave){
    $slave_info[] = NED::div([NED::str('siteconnectreplica'), ': ', $fa($slave_connect, true)]);
    $slave_info[] =  NED::div('Latency: '.($CFG->dboptions['readonly']['latency'] ?? '-'));
}
NED::ediv($slave_info, 'mb-3');

if ($action){
    set_time_limit(HOURSECS);
    $url = new moodle_url($url, [NED::PAR_ACTION => $action, $PARAM_N => $N, $PARAM_DEBUG => $debug_on]);
    $run_curls = function($session_count=10, $url_params=[]) use (&$url, $PARAM_THREAD){
        $curls = [];
        $mh = curl_multi_init();
        for ($i=0; $i<$session_count; $i++){
            $curls[$i] = curl_init();
            $params = array_merge($url_params, [$PARAM_THREAD => $i+1]);
            $th_url = new moodle_url($url, $params);
            curl_setopt($curls[$i], CURLOPT_URL, $th_url->out(false));
            curl_setopt($curls[$i], CURLOPT_HEADER, 0);
            curl_setopt($curls[$i], CURLOPT_SSL_VERIFYPEER, false);

            curl_multi_add_handle($mh, $curls[$i]);
        }

        do {
            $status = curl_multi_exec($mh, $active);
            if ($active) {
                curl_multi_select($mh);
                usleep(1000);
            }
        } while ($active && $status == CURLM_OK);

        for ($i=0; $i<$session_count; $i++){
            curl_multi_remove_handle($mh,  $curls[$i]);
        }
        curl_multi_close($mh);
    };
    $get_db_type = function($db_option) use (&$slave_connect, &$DB_CUSTOM){
        if ($db_option == $DB_CUSTOM){
            $type = NED::str('db_benchmark:db3');
        } else {
            $type = NED::str($slave_connect ? 'db_benchmark:db1' : 'db_benchmark:db2');
        }
        return $type;
    };

    NED::ediv(NED::str('db_benchmark:testintro', ['n' => $N, 'min' => $S_MIN, 'max' => $S_MAX]), 'bold');
    if ($orig_only) echo NED::html_i(NED::str('db_benchmark:originalison'));

    $sessions = range($S_MIN, $S_MAX, $S_step);
    $db_test_options = [$DB_ORIG];
    if (!$one_db_use) $db_test_options[] = $DB_CUSTOM;

    $head = [NED::str('sessions')];
    $cats = ['time', 'completion'];
    foreach ($db_test_options as $db_test_option){
        foreach ($cats as $item){
            $head[] = $get_db_type($db_test_option).', '.NED::str($item);
        }
    }
    if (!$one_db_use){
        $head[] = NED::str('db_benchmark:bonus');
    }
    $table = NED::html_table('', null, $head);

    // add progressbar
    echo \html_writer::start_div('w-50 mt-3');
    $progressbar = new \progress_bar('db_benchmark_'.random_string(4), 500, true);
    echo \html_writer::end_div();
    $a = [
        'count' => count($sessions),
        'done'  => 0,
    ];
    $progressbar->update($a['done'], $a['count'], NED::str('checktests', $a));

    $test_params = ['plugin' => NED::CTRL, 'name' => $test_name.'%'];
    $data_params = ['plugin' => NED::CTRL, 'name' => $data_name.'%'];
    // try to delete old values, just in case
    $DB->delete_records_select($T, $select_cond, $test_params);
    $DB->delete_records_select($T, $select_cond, $data_params);

    // fill test data
    $data = [];
    for ($i=0; $i<$N; $i++){
        $data[] = (object)['plugin' => NED::CTRL, 'name' => $test_name.'_'.$i, 'value' => $i];
    }
    $DB->insert_records($T, $data);

    // run sessions
    foreach ($sessions as $session_i){
        $row = NED::row([$session_i]);
        $data_res_time = [];

        foreach ($db_test_options as $db_option){
            $call_params = [$PARAM_DB => $db_option];
            $run_curls($session_i, $call_params);
            $records = $DB->get_records_select($T, $select_cond, $data_params);
            $s_val = 0;
            $val_data = [];

            foreach ($records as $record){
                if (isset($record->value)){
                    $val = json_decode($record->value);
                    if (isset($val->res)){
                        $s_val += $val->res;
                        $val->res = NED::time_diff_to_str_max_hr($val->res, 0, 2);
                    }

                    if ($debug_on){
                        $r_data = [];
                        foreach ($val as $key => $item){
                            $r_data[] = "$key: $item";
                        }
                        $val_data[] = NED::div(join(', ', $r_data), 'm-1');
                    }
                }
            }

            $data_res_time[$db_option] = $s_val;
            $s_val = NED::time_diff_to_str_max_hr($s_val, 0, 2);
            $c_records = count($records);
            $row->cells[] = $s_val; // time
            $done = round($c_records/$session_i*100);
            $row->cells[] = NED::cell($done.'%', $done < 100 ? 'alert-danger' : '');

            if ($debug_on){
                $type = $get_db_type($db_option);
                NED::ediv("$session_i sessions, $type: $s_val, $c_records really worked sessions");
                if (!empty($val_data)){
                    NED::ediv($val_data, 'm-2');
                }
            }

            $DB->delete_records_select($T, $select_cond, $data_params);
        }
        if (!$one_db_use) {
            $row->cells[] = $count_bonus($data_res_time[$DB_CUSTOM], $data_res_time[$DB_ORIG]);
        }
        $table->data[] = $row;
        $a['done']++;
        $progressbar->update($a['done'], $a['count'], NED::str('checktests', $a));
    }
    // done
    $progressbar->update($a['done'], $a['count'], NED::str('done'));
    echo NED::render_table($table, 'm-2',true);

    // clear
    $DB->delete_records_select($T, $select_cond, $test_params);

    NED::ediv([NED::str('testdate'), ': ', NED::ned_date(time())]);
    NED::ediv([NED::str('testduration'), ': ', NED::time_diff_to_str_max_hr($T1, null, 2)]);

    $url->remove_all_params();
    NED::ediv(NED::link([$url], get_string('ok'), 'btn btn-primary'), 'row justify-content-around mt-5');
} else {
    $cron_e = get_config('core', 'cron_enabled');
    echo NED::div([NED::str('recommendedoffcron'), ' ',
                   NED::link(['/admin/settings.php', ['section' => 'taskprocessing']], get_string('settings'))]);
    if ($cron_e){
        echo NED::notification(NED::str('cronenabled'), NED::NOTIFY_WARNING, false);
    } else {
        echo NED::notification(NED::str('crondisabled'), NED::NOTIFY_SUCCESS, false);
    }

    $tasks_count = count(\core\task\manager::get_running_tasks());
    echo NED::div([NED::str('recommendedtasksfinish'), '',
                   NED::link(['/admin/tool/task/runningtasks.php'], get_string('runningtasks', 'tool_task'))]);
    echo NED::notification(NED::str('tasksrunning', $tasks_count),
        $tasks_count > 0 ? NED::NOTIFY_WARNING : NED::NOTIFY_SUCCESS, false);

    echo NED::html_i(NED::str('db_benchmark:warning'));

    $buttons1 = [];
    $buttons2 = [];
    foreach ([4, 8, 16, 32] as $item){
        $buttons1[] = NED::link([$url, [NED::PAR_ACTION => true, $PARAM_SMAX => $item]],
            NED::str('db_benchmark:starttest', $item), 'btn btn-primary m-1');
        $buttons2[] = NED::link([$url, [NED::PAR_ACTION => true, $PARAM_SMAX => $item, $PARAM_ORIG_ONLY => true]],
            NED::str('db_benchmark:starttest:alone', $item), 'btn btn-secondary m-1');
    }

    NED::ediv([NED::div($buttons1, 'row m-2 justify-content-around'),
               NED::div($buttons2, 'row m-2 justify-content-around')], 'mt-5');
}

echo $OUTPUT->footer();
