<?php
/**
 * @package    local_ned_controller
 * @subpackage lang
 * @category   NED
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$pref = 'custom_ned_menu_';
$string[$pref.'common_format'] =
    "Enter each menu item on a new line with format: title, " .
        "a link URL (optional) and role restrictions (optional), separated by pipe (|) characters.";
$string[$pref.'item_0'] = 'Lines enclosed in square brackets will be displayed as the top-level menu, for example: [Course|#section-1]';
$string[$pref.'item_1'] = 'Simple lines will be the top-level menu after the lines in square brackets.';
$string[$pref.'item_2'] = 'Lines starting with a hyphen will appear as menu items in the previous top level menu, ' .
    'where the number of hyphens indicates the nesting level of that menu.';
$string[$pref.'item_3'] = 'Lines starting with a # will be hidden for everyone';
$string[$pref.'examples'] = 'Examples:';
$string[$pref.'code_example'] =
    "[UNIT 1|#section-4]\n" .
    "Tests\n" .
    "- UNIT 1 TESTS; fa-clock-o; red; blueviolet\n" .
    "# Here are all our quizzes for Unit 1\n" .
    "-- 1-1: Unit Highlights|#section-4\n" .
    "-- 1-2: Unit 1 Study Guide & Test Outline|#\n" .
    "Teacher Tools|/blocks/ned_teacher_tools/student_progress.php?courseid=8978|-student\n";
$string[$pref.'parameters_information'] = 'Further information to the parameters:';
$string[$pref.'title'] = 'Title';
$string[$pref.'title_desc'] = 'Title has format: text; icon; icon-color; background-color (all is optional)';
$string[$pref.'title_text'] = 'text - this text will be shown as the clickable text / label of the custom node';
$string[$pref.'title_icon'] = 'icon - is a {$a->link} icon class. For example, "fa-circle" is {$a->icon}';
$string[$pref.'title_color'] = 'icon-color - is color of the icon. It can be a color name (e.g. "blue") or hex color code as "#0000ff" or "0000ff". '.
    'For example, "fa-circle; blue" is {$a->icon}';
$string[$pref.'title_bg_color'] = 'background-color - is color of item background, the same rules as for "color" applies';
$string[$pref.'url'] = 'Link URL';
$string[$pref.'url_desc'] = 'Item link, which can be specified as follows:';
$string[$pref.'url_0'] = '# - which means link to the activity with the same name as item title';
$string[$pref.'url_1'] = '#section-X - which means link to specific (X) section of the course';
$string[$pref.'url_2'] = 'a relative path within your Moodle instance (e.g. /my)';
$string[$pref.'url_3'] = 'a full web URL (e.g. https://moodle.org)';
$string[$pref.'role'] = 'Role restrictions';
$string[$pref.'role_desc_0'] = 'Role restrictions defines who can view item element. ' .
    'If the item has children elements and user cannot view this item, then this item and its children will be hidden.';
$string[$pref.'role_desc_1'] = 'If a role name begins with the hyphen, that means that the user shouldn\'t have this role to view the item.';
$string[$pref.'role_desc_2'] = 'You can to specifier several role rules separated by semicolon, ' .
    'then user will see the item if at least one of the rules is met.';
$string[$pref.'role_desc_3'] = 'Example: "student; -Classroom Teacher [CT]" will show the item for users, ' .
    'who has role "Student" or hasn\'t role "Classroom Teacher [CT]".';
$string[$pref.'rolename_desc'] = 'Role name can be one of the follows (all options are case-insensitive):';
$string[$pref.'rolename_option_0'] = 'role id';
$string[$pref.'rolename_option_1'] = 'role system name';
$string[$pref.'rolename_option_2'] = 'role human name';
$string[$pref.'rolename_option_3'] = 'role course alias from the course settings';
$string[$pref.'rolename_warn'] = 'Warning: if you specify a role that does not exist, only the administrator will be able to see this item.';
