<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    local_ned_controller
 * @subpackage NED
 * @copyright  2018 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @developer  G J Barnard - {@link http://about.me/gjbarnard} and
 *                           {@link http://moodle.org/user/profile.php?id=442195}
 */

require(__DIR__.'/ned_grade_controller.php');
require(__DIR__.'/themes.php');
require(__DIR__.'/marking_manager.php');
require(__DIR__.'/tt_and_sm.php');
require(__DIR__.'/custom_ned_menu.php');
require(__DIR__.'/ned_notifications.php');

use local_ned_controller\deadline_notification as DN;

$string['pluginname'] = 'NED Controller';

// Capabilities.
$string['ned_controller:revokebadge'] = 'Revoke badge';
$string['ned_controller:dn_seeownnotifications'] = 'Deadline notification modals: Can see own notifications';
$string['ned_controller:dn_seeowngroupsnotifications'] = 'Deadline notification modals: Can see notifications for own course group';
$string['ned_controller:preventquizpreviewsummative'] = 'Prevent preview summative quizzes';
$string['ned_controller:editothersubmission'] = 'Edit another student\'s submission (including submit on behalf of student)';
$string['ned_controller:viewgradesbeforemidn'] = 'View new grades before 23:59';
$string['ned_controller:viewassignsubmissionconfirmation'] = 'View assign submission confirmation';
$string['ned_controller:viewfulluserprofile'] = 'Can view full user profile';
$string['ned_controller:viewallparticipantcolumns'] = 'Can view Groups and Last Access columns in participants list';

// Events
$string['eventsubmissionremoved'] = 'Submission removed.';
$string['eventsubmissiongradescleared'] = 'Submission grades cleared.';
$string['eventsubmissionforceaddattempt'] = 'Submission force add attempt.';

$string['controlpanel'] = 'Control panel';

$string['categoryicons'] = 'Category icons';
$string['categoryiconscategory'] = 'Category';
$string['categoryiconsfontawesome'] = 'FontAwesome code';
$string['categoryiconsformat'] = 'Format: ';
$string['categoryiconsjsonfail'] = 'Setting value is not in a valid format to be stored.';
$string['categoryiconssemi'] = '. If another line is to follow, end with a semi-colon \';\' <br/><br/>Options:<br/><b>category:</b> exact name of the category to match<br/><b>icon:</b> see <a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">https://fontawesome.com/v4.7.0/icons/</a><br/><div style="color: green;">Examples:<br/>Math, fa-square-o;<br/>Science, fa-flask</div><br/>';

$string['quicklinkscourseheader'] = 'Quick links in course header';
$string['quicklinkscoursename'] = 'Quick link next to the course name';

$string['quicklinkscourseparticpants'] = 'Course participants';
$string['quicklinkscourseparticpants_desc'] = 'Only if the user has the capability \'moodle/course:viewparticipants\'.';

$string['quicklinkseditsettings'] = 'Edit settings';
$string['quicklinkseditsettings_desc'] = 'Only if the user has the capability \'moodle/course:update\'.';

$string['quicklinksgradebook'] = 'Gradebook';
$string['quicklinksgradebook_desc'] = 'Only if the user has the capability \'moodle/grade:viewall\'.';

$string['quicklinksmanualenrollment'] = 'Manual enrollment';
$string['quicklinksmanualenrollment_desc'] = 'Only if the user has the capability \'enrol/manual:manage\'.';
$string['quicklinksmanualenrollments'] = 'Manual enrollments';

$string['quicklinksnedprogressreport'] = 'NED Progress Report';
$string['quicklinksnedprogressreport_desc'] = 'Only if the user has the capability \'block/ned_teacher_tools:viewblock\'.';

$string['quicklinksnedmarkingmanager'] = 'NED Marking Manager';
$string['quicklinksnedmarkingmanager_desc'] = 'Only if the user has the capability \'block/ned_teacher_tools:viewblock\'.';

$string['quicklinksnedstudentmenu'] = 'My Progress';
$string['quicklinksnedstudentmenu_desc'] = 'Only if the user has the capability \'block/ned_student_menu:viewblock\'.';

$string['pluginsoverview'] = 'NED Plugins Overview';
$string['overview'] = 'Overview';
$string['block'] = 'Block';
$string['theme'] = 'Theme';
$string['mod'] = 'Mod';
$string['format'] = 'Format';
$string['local'] = 'Local';
$string['filter'] = 'Filter';
$string['open'] = 'Open';
$string['updatenedpluginsinfo'] = 'Update NED plugins info';
$string['cleardeletedusers'] = 'Clear deleted users from the NED tables';
$string['deadline_notification_update'] = 'Update Deadline Notifications';
$string['adhoc_deadline_notification_update'] = 'Adhoc Update Deadline Notifications';
$string['notinstalled'] = 'Not installed';
$string['updateavailable'] = 'Update Available';
$string['latestversion'] = 'Latest Version';
$string['plugin_name'] = 'Plugin name';
$string['type'] = 'Type';
$string['instances'] = 'Instances';
$string['info'] = 'Info';
$string['settings'] = 'Settings';
$string['version'] = 'Version';
$string['medsettings'] = 'NED Settings';
$string['license'] = 'License';
$string['support'] = 'Support';
$string['valid'] = 'Valid';
$string['invalid'] = 'Invalid';
$string['teacher'] = 'Teacher';
$string['department'] = 'Department';
$string['school'] = 'School';
$string['forum'] = 'Forum';
$string['hvp'] = 'H5P';
$string['email'] = 'Email';
$string['qrticket'] = 'QR Ticket';
$string['quicklinkscourseheaderboosttheme'] = 'NED Boost Theme - Quick links in course header';
$string['quicklinkscoursenamenedformat'] = 'NED Course Format - Quick link next to the course name';
$string['checkforupdates'] = 'Check for updates';
$string['courseinstances'] = 'Course instances';
$string['expires'] = 'Expires';
$string['unlimited'] = 'Unlimited';

$string['years'] = 'years';
$string['year'] = 'year';
$string['months'] = 'months';
$string['month'] = 'month';
$string['weeks'] = 'weeks';
$string['week'] = 'week';
$string['days'] = 'days';
$string['day'] = 'day';
$string['hours'] = 'hours';
$string['hour'] = 'hour';
$string['minutes'] = 'minutes';
$string['minute'] = 'minute';
$string['seconds'] = 'seconds';
$string['second'] = 'seconds';
$string['milli_s'] = 'ms';
$string['micro_s'] = 'μs';
$string['nano_s'] = 'ns';

$string['rules'] = 'Rules';
$string['rules_desc'] = 'Rules created here will be applied to the NED Boost and NED Clean themes.';
$string['logo'] = 'Logo';
$string['id'] = 'ID';
$string['name'] = 'Name rule';
$string['availability'] = 'Availability';
$string['logo_help'] = 'A full logo to be used as decoration by some themes (such as core themes). This image can be quite high resolution because it will be scaled down for use (and cached for performance). Logos that are wider than they are high usually give better results. Formats accepted: PNG and JPG.';
$string['compactlogo'] = 'Compact logo';
$string['compactlogo_help'] = 'A compact version of the same logo as above, such as an emblem, shield or icon. The image should be clear even at small sizes. Formats accepted: PNG and JPG.';
$string['customcss'] = 'Custom CSS';
$string['customcss_help'] = 'Use this field to provide CSS code that will be added to the end of the head tag.';
$string['additionalhtmlhead'] = 'Within HEAD';
$string['additionalhtmlhead_help'] = 'Content here will be added to the bottom of the HEAD tag for every page.';
$string['additionalhtmltopofbody'] = 'When BODY is opened';
$string['additionalhtmltopofbody_help'] = 'Content here will be added in to every page immediately after the opening body tag.';
$string['additionalhtmlfooter'] = 'Before BODY is closed';
$string['additionalhtmlfooter_help'] = 'Content here will be added in to every page right before the body tag is closed.';
$string['loggedinredirect'] = 'Redirect after login';
$string['loggedinredirect_help'] = 'Redirect user to the page after his login';
$string['ruleremoved'] = 'Rule removed';
$string['rulecreated'] = 'Rule created';
$string['ruleupdated'] = 'Rule updated';
$string['addrule'] = 'Add rule';
$string['weight'] = 'Weight';
$string['weight_help'] = 'This field allows you to customize the display order.';
$string['disabled'] = 'Disabled';
$string['disabled_help'] = 'This field allows you to disable the rules.';
$string['true'] = 'True';
$string['false'] = 'False';
$string['status'] = 'Status';
$string['ned_school_year_start'] = 'NED School Year start';
$string['ned_school_year_start_help'] = 'Current school year start date for Grade Penalties and Academic Integrity violation records';
$string['ned_school_year_title'] = 'School year';
$string['ned_school_year_current'] = 'Current';
$string['ned_school_year_past'] = 'Past';
$string['ned_school_year_all'] = 'All';

$string['themerulesheader'] = 'NED Theme Rules';
$string['managerules'] = 'Theme customization';
$string['popupnotifications'] = 'Pop-up notifications';

$string['add_condition'] = 'Add condition';
$string['profile_field'] = 'Profile field';
$string['courses_category'] = 'Courses category';
$string['cancel'] = 'Cancel';
$string['user_must_match'] = 'User must match';
$string['of_the_following'] = 'of the following';
$string['or'] = 'or';
$string['and'] = 'and';
$string['category'] = 'Category';
$string['user_profile_field'] = 'User profile field';
$string['is_equal_to'] = 'contains';
$string['doesnt_contain'] = 'doesn\'t contain';
$string['must'] = 'must';
$string['must_not'] = 'must not';
$string['any'] = 'Any';

$string['close'] = 'Close';

$string['nedcontrollersettings'] = 'NED Controller Settings';
$string['opennedcontrollersettings'] = 'Open NED Controller';
$string['controllersettings'] = 'Controller settings';
$string['type'] = 'Type';
$string['saveasnew'] = 'Save as new';

$dn = 'deadline_notification';
$h12 = DN::COND_DUE_12h;
$over = DN::COND_OVERDUE;
$st = DN::STUDENT;
$gr = DN::GRADER;
$string['attention_username'] = 'Attention {$a}';
$string["$dn:$over:$gr:text"] = 'The following activities were not received by one or more students in your class, and the deadlines have now passed. 
A soft-zero has been awarded for each missing submission. If a student has a valid reason for missing a due date, 
the CT has 4 days (from original deadline) to award a deadline extension.  
If an extension is not awarded, the student has 10 days to upload a late submission. Note that a 20% deduction is applied to all late submissions. 
After 10 days, late submissions are not accepted, and a hard-zero is awarded.';
$string["$dn:$h12:$gr:text"] = "The following assignments have not been submitted and are due in less than 12 hours. 
If any student in your class is unable to meet a deadline, and she/he has a valid reason, 
please award a due date extension before the deadline expires. Please also remind student to check their work carefully before uploading files.";
$string["$dn:$h12:$st:text"] = 'The following assignments have not been submitted and are due in less than 12 hours. 
If you are not able to meet a deadline, and you have a valid reason, please contact your classroom teacher to request an extension. 
Please remember to check your work carefully before uploading files.';
$string["$dn:$over:$st:text"] = 'The following activities were not received, and the deadlines have now passed. 
A grade of zero has been awarded. At this time you may request a new deadline from your Classroom Teacher. Note that late submissions are also accepted for up to 10 days after the deadline. 
A 20% deduction is applied to all late submissions. After 10 days, late submissions are not accepted. 
Please contact your Classroom Teacher if you have any questions.';
$string["$dn:$over:title"] = 'Missed Deadline – No Submission Received';
$string["$dn:$h12:title"] = 'Upcoming Deadlines – Less Than 12 Hours';

$string['preview'] = 'Preview';
$string['loading'] = 'Loading...';
$string['revokebadge'] = 'Revoke badge';
$string['revokebadgeconfirm'] = 'Do you really want to revoke this badge?';
$string['general'] = 'General';
$string['redirecttodraft'] = 'Redirect to the drat submissions';
$string['draft_warning'] = '<h5 class="red">Draft file detected.</h5>
Please click the "submit assignment" button below to submit your work for grading.';
$string['error_nopluginpath'] = "Can't find plugin directory!";
$string['course'] = 'Course';
$string['class'] = 'Class';
$string['activity'] = 'Activity';
$string['firstname'] = 'first name';
$string['lastname'] = 'last name';
$string['due_24h'] = 'Due -24hrs';
$string['due_12h'] = 'Due -12hrs';
$string['overdue'] = 'Overdue';
$string['ct'] = 'CT';
$string['ot'] = 'OT';
$string['resubmission'] = 'Resubmission';
$string['addedsuccessfully_records'] = 'Successfully added {$a} record(s)';
$string['norecords'] = 'No records';
$string['addrecord'] = 'Add record';
$string['sorry_no_smth'] = 'Sorry, there are no {$a} to choose.';
$string['havethisstudent'] = 'A record for this student already exists.';
$string['addrecord2smth'] = 'Add record to the {$a}';
$string['award_smth'] = 'Award {$a}';
$string['classenddate'] = 'Class End Date';
$string['academicintegrityinfractions'] = 'Academic Integrity Manager';
$string['infraction'] = 'Infraction';
$string['infractiontype'] = 'Infraction Type';
$string['opensomepage'] = 'Open «{$a}» page';
$string['applying'] = 'Applied';
$string['changedby'] = 'Changed by {$a}';
$string['createdby'] = 'Created by {$a}';
$string['created'] = 'Created';
$string['coursepage'] = 'Course page';
$string['sitepage'] = 'Site page';
$string['reset'] = 'Reset';
$string['nosuchrecord'] = 'There is no such record';
$string['nosuchrecords'] = 'There is no such record(s)';
$string['norecordwithid'] = 'There is no record with id "{$a}"';
$string['see_sth'] = 'See {$a}';
$string['add_sth'] = 'Add {$a}';
$string['award_sth'] = 'Award {$a}';
$string['showall'] = 'Show all';
$string['hideall'] = 'Hide all';
$string['can_award_extension'] = 'Can award extension';
$string['mustinstallplugin'] = 'You must install NED Controller plugin “{$a->plugin}” version {$a->version} or upper.';
$string['mustupdateplugin'] = 'You must update NED Controller plugin “{$a->plugin}” to version {$a->version} or upper.';
$string['shouldupdateplugin'] = 'You should update NED Controller plugin “{$a->plugin}” to version {$a->version} or upper.';
$string['count_check_events_warning'] = 'Event "{$a->event}" repeated {$a->i} times already from the {$a->plugin}, possible infinite loop, pass.';
$string['done'] = 'Done';
$string['error_cantcreatefile'] = "Error: Cannot create the file.";
$string['othertasks_warning'] = 'There is other tasks, which have not completed yet, pass';
$string['system'] = 'System';
$string['automaticcreatedrecord'] = 'SYSTEM: Automatically created record ({$a})';
$string['automaticchangedrecord'] = 'SYSTEM: Automatically changed record ({$a})';
$string['hidden'] = 'Hidden';
$string['restricted'] = 'Restricted';
$string['bulk_action'] = 'Bulk action';
$string['noselectedrecords'] = 'There are no selected records!';
$string['nonewrecords'] = 'There are no new records.';
$string['view'] = 'View';
$string['add'] = 'Add';
$string['edit'] = 'Edit';
$string['delete'] = 'Delete';
$string['continue'] = 'Continue';
$string['expired'] = 'Expired';
$string['unavailable'] = 'Unavailable';
$string['ok'] = 'OK';
$string['?'] = '?';
$string['wishcontinue'] = 'Do you wish to continue?';
$string['x_ago'] = '{$a} ago';
$string['after_x'] = 'After {$a}';
$string['enablegroupconversation'] = 'Enable group conversations';
$string['grade_empty_resubmissions_task'] = 'Task copies previous grades for unmarked, ungraded and passed deadline resubmissions, and locks it';
$string['selectactivity'] = 'Select activity';

$string['db_benchmark'] = 'DB Benchmark';
$string['checktests'] = 'Test {$a->done}/{$a->count}...';
$string['sessions'] = 'Sessions';
$string['testdate'] = 'Test date';
$string['testduration'] = 'Test duration';
$string['cronenabled'] = 'Cron enabled';
$string['crondisabled'] = 'Cron disabled';
$string['recommendedoffcron'] = 'It is recommended to turn off the cron before the test.';
$string['recommendedtasksfinish'] = 'It is recommended to wait until all running tasks finish.';
$string['tasksrunning'] = 'There are {$a} tasks running now.';
$string['db_benchmark:warning'] = 'Keep in mind that the test can take a considerable amount of time, '.
    'and it can be inconvenient for other users on the site.';
$string['db_benchmark:testintro'] = 'Test read/update {$a->n} records with {$a->min}-{$a->max} sessions.';
$string['db_benchmark:originalison'] = 'Mode "only original database" is on.';
$string['db_benchmark:db1'] = 'Original DB (with replica)';
$string['db_benchmark:db2'] = 'Original DB (without replica)';
$string['db_benchmark:db3'] = 'Custom DB (without replica)';
$string['completion'] = 'Completion';
$string['time'] = 'Time';
$string['db_benchmark:bonus'] = 'Replica performance bonus';
$string['sitehasreplica'] = 'Site has replica';
$string['siteconnectreplica'] = 'Site can connect to the replica';
$string['db_benchmark:starttest'] = 'Start test with {$a} sessions, two DB types';
$string['db_benchmark:starttest:alone'] = 'Start test with {$a} sessions, only original DB';
$string['change'] = 'Change';
$string['completedcourse:nosubmissionsallowed'] = 'You have completed this course: No further submissions are allowed.';
$string['gt_user_update'] = '[GM] Update user';
$string['graderpage'] = 'Grader page';
$string['sitedefault_x'] = 'Site default [{$a}]';
$string['base_task_maple_warning'] = '"{$a}" task is disabled for the Maple server, pass';
$string['updateactivityraid'] = 'Update activity RAID + REGT';

// Caches description
$string['cachedef_notification'] = 'Cache for local/ned_controller/classes/ned_notifications.php';
$string['cachedef_users'] = 'Session cache of user notification';
$string['updateuserinstitutionwithprofilefield'] = 'Update user institution field with profile field value';
