<?php
/**
 * @package    local_ned_controller
 * @subpackage lang
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_ned_controller\ned_grade_controller as NGC;

$string['gradecontroller'] = 'Grade Penalty Controller';
$p = NGC::S_GT_PREFIX;
$string['gradetype'] = 'Grade Type';
$string[$p.NGC::GT_AWARD_ZERO] = 'Zero Grade';
$string['type-deduction'] = $string[$p.NGC::GT_DEDUCTION] = 'Deduction';
$p = NGC::S_REASON_PREFIX;
$string['reason'] = 'Reason';
$string[$p.NGC::REASON_AI] = 'Academic Integrity Violation';
$string[$p.NGC::REASON_FILE] = 'Wrong submission';
$string[$p.NGC::REASON_SUBMISSION] = 'Missed Deadline';
$string[$p.NGC::REASON_OTHER] = 'Other';
$p = NGC::S_STATUS_PREFIX;
$string[$p.NGC::ST_WAIT] = 'Update in progress';
$string[$p.NGC::ST_DONE] = 'Active';
$string[$p.NGC::ST_PAUSED] = 'Paused + Hidden';
$string[$p.NGC::ST_OBSOLETED] = 'Paused + Visible';
$string[$p.NGC::ST_ERROR] = 'Error';
$string['back'] = 'Back';
$string['ngc_view_record'] = 'View record';
$string['see_ngc_record'] = 'See penalty record';
$string['see_ngc_others'] = 'See others';
$string['see_all_records'] = 'See all records';
$string['see_student_records'] = 'See this student records';
$string['see_cm_records'] = 'See this activity records';
$string['see_own_records'] = 'See own records';
$string['see_grader_records'] = 'See this grader records';
$string['ngc_pause'] = 'Pause + Hide';
$string['ngc_unpause'] = 'Unpause';
$string['ngc_obsolete'] = 'Pause + Show';
$string['ngc_delete'] = 'Delete record';
$string['ngc_deleterecords'] = 'Delete records';
$string['ngc_removedsuccessfully'] = 'Deleted successfully';
$string['ngc_removedsuccessfully_records'] = 'Successfully deleted {$a} record(s)';
$string['ngc_addedsuccessfully'] = 'Added successfully';
$string['ngc_addedsuccessfully_records'] = 'Successfully added {$a} record(s)';
$string['ngc_pausedsuccessfully'] = 'Set “Paused + Hidden” successfully';
$string['ngc_unpausedsuccessfully'] = 'Unpaused successfully';
$string['ngc_pausedsuccessfully_records'] = 'Successfully set “Paused + Hidden” {$a} record(s)';
$string['ngc_unpausedsuccessfully_records'] = 'Successfully unpaused {$a} record(s)';
$string['ngc_obsoletesuccessfully'] = 'Set “Paused + Visible” successfully';
$string['ngc_obsoletedsuccessfully_records'] = 'Successfully set “Paused + Visible” {$a} record(s)';
$string['wrongsubmission_draft'] = 'Wrong submission > Draft';
$string['wrongsubmission_cancelled'] = 'Wrong submission > Cancelled';
$string['wrongsubmission_fixed'] = 'Wrong submission > Fixed';
$string['wrongfilesubmission'] = 'Wrong File Submission';
$string['soft_zero'] = 'Soft Zero';
$string['hard_zero'] = 'Hard Zero';
$string['ned_controller:gradecontroller_seeme'] = 'Grade Penalty Controller: see own records (as student)';
$string['ned_controller:gradecontroller_seeown'] = 'Grade Penalty Controller: see own grader records';
$string['ned_controller:gradecontroller_seeschool'] = 'Grade Penalty Controller: see records for own school';
$string['ned_controller:gradecontroller_seeall'] = 'Grade Penalty Controller: see all records';
$string['ned_controller:gradecontroller_edit'] = 'Grade Penalty Controller: edit records';
$string['noaireport'] = 'There are no AI Reports that correspond to the selected student in this activity. '.
    'A zero grade cannot be awarded for Academic Integrity reasons without an existing Academic Integrity report.';
$string['NGC_confirm_view'] = $string['NGC_confirm_edit'] = $string['NGC_confirm_add'] = 'Do you want to save this information?';
$string['NGC_confirm_delete'] = 'Do you want to delete this information? This action cannot be undone.';
$string['NGC_confirm_pause'] = 'Do you want to pause this record? It will still be shown in the table, but will not affect the student grade.';
$string['NGC_confirm_unpause'] = 'Do you want to unpause this record? This may affect the student grade.';
$string['ai_records'] = 'AI records';
$string['gradereduction'] = 'Grade reduction';
$string['gradereduction'] = 'Grade reduction';
$string['applygradereduction'] = 'Apply grade reduction (percent)';
$string['gradereduction_rule'] = 'Grade reduction should be between 1 and 99';
$string['choose_ai_record'] = 'Please select the AI record for the student in this activity.';
$string['ned_grade_controller_update'] = 'Grade Controller cronjobs';
$string['adhoc_ned_grade_controller_update'] = 'Adhoc Update Grade Controller';
$string['cron_ngc_enable'] = 'Enable NGC cronjobs';
$string['cron_ngc_enable_help'] = 'If you turn off this option, all NGC crones will be disabled';
$string['cron_ngc_time'] = 'Time for one NGC cronjob (minutes)';
$string['cron_ngc_time_help'] = 'If cronjob runs longer than value of this option, it will try to pause and continue later';
$string['cron_ngc_delay'] = 'NGC cronjob delay (minutes)';
$string['cron_ngc_delay_help'] = 'If NGC cronjob pauses, it will continue after this delay';
$string['cron_ngc_update_enable'] = 'Enable NGC update cronjob';
$string['cron_ngc_missed_deadlines_enable'] = 'Enable NGC cronjob «Auto set Zeros for the Missed deadlines»';
$string['cron_ngc_late_submissions_enable'] = 'Enable NGC cronjob «Auto set Deduction for the Late submissions»';
$string['cron_ngc_fixed_submissions_enable'] = 'Enable NGC cronjob «Auto set Deduction for the Fixed submissions»';
$string['adhoc_cron_ngc_missed_deadlines'] = 'Cron Auto set Zeros for the Missed deadlines';
$string['adhoc_cron_ngc_late_submissions'] = 'Cron Auto set Deduction for the Late submissions';
$string['adhoc_cron_ngc_fixed_submissions'] = 'Cron Auto set Deduction for the Fixed submissions';
$string['reportaiviolation'] = 'Report AI Violation';
$string['reportwrongfilesubmission'] = 'Report Wrong File Submission';
$string['ngc_delete_error_missed_deadlines'] = 'This record connected to Missed deadline - '.
    'please, change deadline first, if you wish to delete the record.';
$string['ngc_delete_error_missed_deadlines_format'] = 'The record of {$a->cm} for {$a->student} can not be deleted, '.
    'as it connected to Missed deadline - please, change deadline ({$a->deadline_str}) first, if you wish to delete this record.';
$string['ngc_change_status_error'] = 'This record has “error” status and can not change it. You still can edit or delete it.';
$string['ngc_change_status_error_format'] = 'The record of {$a->cm} for {$a->student} '.
    'has “error” status and can not change it. You still can edit or delete it.';
$string['wrongfiles_draft_warning'] =
    "The Grading Teacher has found that you have submitted the wrong file for this assignment.\n".
    "You may upload the correct file now by clicking on the “Edit submission” button below.\n".
    "You also have the option to remove your submission. Note that if you remove the submission and the deadline has already passed, ".
    "you will need to request a new deadline from your Classroom Teacher.\n\n".
    "You will not be able to complete other activities until this issue has been resolved. ".
    "In the future, please remember to check your files carefully before submitting.";
$string['wrongfiles_what_happens_q'] = 'What happens when a submitted file is flagged as a "wrong submission"?';
$string['wrongfiles_desc_options'] = 'After next login, the student will not be able to navigate away from the submission page 
    until one of these options are selected:';
$string['wrongfiles_desc_option1'] = 'Replace file: Student uploads a new file.';
$string['wrongfiles_desc_option2'] = 'Cancel submission: File is deleted. 
    The student is then able to upload a new file up until the deadline arrives. 
    If the deadline has passed, it will be treated as a missed submission.';
$string['warn:wrongrecord'] = 'Wrong record!';
$string['warn:seeyourrecords'] = 'You can see only your records!';
$string['ngc:repeats'] = 'Repeats';
$string['ngc:repeats:title'] = 'Infractions repeat';
$string['ngc:repeats:hide'] = '&nbsp; — &nbsp;';
$string['ngc:repeats:show'] = 'Show repeats';
$string['ngc:repeats:option_1'] = '1';
$string['ngc:repeats:option_2'] = '2';
$string['ngc:repeats:option_3_plus'] = '3+';
$string['ngc:repeats:option_5_plus'] = '5+';
$string['ngc:repeats:option_10_plus'] = '10+';
$string['ngc:profile_table_title'] = 'Other Academic Infractions';
