<?php
/**
 * @package    local_ned_controller
 * @subpackage lang
 * @category   NED
 * @copyright  2023 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['no_notifications'] = 'There are currently no Notifications.';

$string['notifications_desc'] = 'Notifications created here will be shown across the entire site.';
$string['notifications:add'] = 'Add notification';
$string['notifications:removed'] = 'Notification "{$a}" removed';
$string['notifications:created'] = 'Notification "{$a}" created';
$string['notifications:updated'] = 'Notification "{$a}" updated';
$string['notifications:copied'] = 'Notification "{$a}" copied';
$string['notifications:confirm_removed'] = 'Are you sure you want to delete this notification?';
$string['notifications:weight'] = 'Weight';
$string['notifications:weight_help'] = 'Notifications with bigger weight will be shown earlier.';
$string['notifications:conditions'] = 'Conditions';
$string['notifications:disabled'] = 'Disabled';
$string['notifications:disabled_help'] = 'This field allows you to disable the notification.';

$string['notifications:type'] = 'Notification type';
$string['notifications:type:message'] = 'Message';
$string['notifications:type:info'] = 'Did you know...';
$string['notifications:type:reminder'] = 'Reminder';
$string['notifications:type:notice'] = 'Notice';
$string['notifications:title:message'] = 'Announcement';
$string['notifications:title:info'] = 'Did you know...';
$string['notifications:title:reminder'] = 'Reminder';
$string['notifications:title:notice'] = 'Notice';

$string['notifications:rule'] = 'Condition match rule';
$string['notifications:rule_help'] = 'If user must match ALL the conditions and condition list is empty, all users will see the message.<br>
    If user must match ANY of the conditions and condition list is empty, nobody will see the message - but you can still add users manually in "Show message for these users" option.';
$string['notifications:rule:or'] = 'User must match ANY of the conditions';
$string['notifications:rule:and'] = 'User must match ALL of the conditions';

$string['notifications:description'] = 'Description';
$string['notifications:add_condition'] = 'Add condition';
$string['notifications:choose_condition'] = '=== Choose Condition ===';

$string['notifications:profile'] = 'Profile field';
$string['notifications:profile:match'] = 'is equal to';
$string['notifications:profile:not_match'] = 'doesn\'t contain';

$string['notifications:cohort'] = 'Cohort';
$string['notifications:cohort:match'] = 'is member of';
$string['notifications:cohort:not_match'] = 'not member of';

$string['notifications:badge'] = 'Badge';
$string['notifications:badge:match'] = 'earned';
$string['notifications:badge:not_match'] = 'did not earn';

$string['notifications:deadline_manager'] = 'Deadline Manager';
$string['notifications:deadline_manager:match'] = 'is complete';
$string['notifications:deadline_manager:not_match'] = 'is not complete';

$string['notifications:kica_gradebook'] = 'KICA Gradebook';
$string['notifications:kica_gradebook:match'] = 'without errors';
$string['notifications:kica_gradebook:not_match'] = 'has error';

$string['notifications:activity'] = 'Course activity completion';
$string['notifications:activity:complex_text'] = 'Activity name [[name_value]] [[equal]]';
$string['notifications:activity:match'] = 'is complete';
$string['notifications:activity:not_match'] = 'is not complete';

$string['notifications:class_time'] = 'Class start-end date';
$string['notifications:class_time:class_start'] = 'Class start date';
$string['notifications:class_time:class_end'] = 'Class end date';
$string['notifications:class_time:complex_text'] = '[[select_type]] is [[more_less]] than [[time_value]] [[before_after]] the current date';

$string['notifications:modaltext'] = 'Modal text';
$string['notifications:courselevel'] = 'Course level';
$string['notifications:courselevel_help'] = 'If checked, Notification will be shown only on course level pages.'.
    '<br>Also influences on available conditions and redirect options.';
$string['notifications:foreachcourse'] = 'For each course';
$string['notifications:foreachcourse_help'] = 'If checked, "Repeat" and "Don\'t show again" options will be counted separately for each course.';
$string['notifications:iteration'] = 'Repeat';
$string['notifications:iteration:once'] = 'Once';
$string['notifications:iteration:thrice'] = '3 times';
$string['notifications:iteration:unlimited'] = 'Until user no longer matches the access restrictions';
$string['notifications:timeout'] = 'Frequency';
$string['notifications:timeout:no'] = 'Every page loading';
$string['notifications:timeout:15min'] = 'Every 15 minutes';
$string['notifications:timeout:hour'] = 'Every hour';
$string['notifications:timeout:bylogin'] = 'After every login';
$string['notifications:timeout:day'] = 'Once per day';
$string['notifications:dontshow'] = 'Add button "Don\'t show again"';
$string['notifications:dontshow_help'] = 'If user clicks "Don\'t show again", this message will not be shown again, despite "Repeat" option.';
$string['notifications:dontshow:text'] = 'Don\'t show again';
$string['notifications:resetviews'] = 'Reset views';
$string['notifications:resetviews_help'] = 'If checked, users will see this notification as if for the first time.';
$string['notifications:shownext'] = 'Show next';
$string['notifications:close'] = 'Close';
$string['notifications:userids_add'] = 'Show message for these users';
$string['notifications:userids_add_help'] = 'These users will see the message, despite "Conditions" option.';
$string['notifications:userids_remove'] = 'Don\'t show message for these users';
$string['notifications:userids_remove_help'] = 'These users will not see the message, despite "Conditions" option.';
$string['notifications:courselevel:icon_title'] = 'Course level condition only';

$string['notifications:redirect:title:selector'] = 'Forward user when modal is closed';
$string['notifications:redirect:title:activity'] = 'Forward user to activity name';
$string['notifications:redirect:title:page'] = 'Forward user to webpage URL';

$string['notifications:redirect:none'] = 'Do not forward';
$string['notifications:redirect:dm'] = 'Deadline Manager';
$string['notifications:redirect:condition_activity'] = 'The first activity from the condition list';
$string['notifications:redirect:other_activity'] = 'Other activity';
$string['notifications:redirect:webpage'] = 'Webpage';

$string['notifications:common:more'] = 'more';
$string['notifications:common:less'] = 'less';
$string['notifications:common:before'] = 'before';
$string['notifications:common:after'] = 'after';

$string['notifications:error:condition'] = 'These is some error with the condition "{$a->condition}".';
$string['notifications:error:element'] = 'These is some error with the element "{$a->element}" for the condition "{$a->condition}".';
