<?php
/**
 * @package    local_ned_controller
 * @subpackage lang
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_ned_controller\shared_lib as NED;

$string['participationpower'] = 'Participation power';
$string['participationpower_title'] = 'Show about Participation score';
$string['participationpower_modal:title'] = 'About your Participation score for {$a}';
$string['participationpower_modal:desc'] = 'Your Participation Power is determined by dividing your Formative score by your Summative score.';
$string['participationpower_modal:summativescore'] = 'Your Summative activities score: {$a}';
$string['participationpower_modal:summativeformula'] = 'Completed successfully + Completed unsuccessfully + Waiting for grade';
$string['participationpower_modal:formativescore'] = 'Your Formative activities score: {$a}';
$string['participationpower_modal:formativeformula'] = 'Completed successfully - Completed unsuccessfully + Waiting for grade';
$string['participationpower_modal:scoredivided'] = 'Your Formative score divided by your Summative score: {$a}';
$string['participationpower_modal:participationpower'] = 'Your Participation power: {$a}';
$string['participationpower_modal:participationpowerformula'] = 'Formative activity score / Summative activity score';
$string['pp-low'] = 'Low';
$string['pp-medium'] = 'Medium';
$string['pp-high'] = 'High';

$string['resubmission_modal:link'] = 'About resubmissions';
$string['resubmission_modal:title'] = 'Resubmissions';
$string['resubmission_modal:header1'] = 'Resubmission rules for this course';
$string['resubmission_modal:point1-1'] = 'You may resubmit <span class="max_attempts">{$a}</span> assignments in this course.';
$string['resubmission_modal:point1-2'] = 'Resubmissions must be submitted within <b>{$a} hours</b> after the grade has been received. '
    . 'During this time, a "Resubmit" button will appear next to the assignment along with a countdown timer, as shown in this example:';
$string['resubmission_modal:point1-3'] = 'Resubmission will not be allowed after the countdown timer has expired.';
$string['resubmission_modal:point1-4'] = 'You must have a <b>High</b> Participation Power rating to resubmit. '
    . 'When an assignment is open for resubmissions, you will only be allowed to resubmit if you have a high Participation Power rating.';
$string['resubmission_modal:header2'] = 'Student Status';
$string['resubmission_modal:point2-1'] = 'Student Participation Power in this course: {$a}';
$string['resubmission_modal:point2-2'] = 'Number of resubmissions that student have submitted in this course:';
$string['resubmission_modal:header3'] = 'How to read the submissions icons';
$string['resubmission_legend:free'] = 'Re-opened (not counted as a resubmission).';
$string['resubmission_legend:done'] = 'Student has resubmitted this activity.';
$string['resubmission_legend:lock'] = 'No further resubmissions are allowed. The resubmission period to this activity has passed.';
$string['resubmission_legend:clock'] = 'The resubmission period has not opened. When it does, student may be allowed to resubmit if you are qualify.';
$string['resubmission_legend:unlock'] = 'Resubmissions are currently being accepted in this activity. You may resubmit within the time limit.';
$string['resubmission_legend:not-allowed'] = 'Resubmissions are currently being accepted in this activity, but student is not qualified.';
$string['resubmission_legend:remove'] = 'Button, which click allow you to cancel empty (not submitted) resubmission.';
$string['cancelresubmissionrequest'] = 'Cancel resubmission request';
//
$string['showsaved'] = 'Show draft activities';
$string['showdraft'] = 'Show draft activities';
$string['keepseparate'] = 'Keep draft assignments separate';
$string['daysnotlogged'] = 'Set number of days not logged';
$string['daysnotsubmited'] = 'Set number of days not submited';
$string['setpercentmarks'] = 'Set the percent of marks';
$string['setblocktitle'] = 'Set block title';
$string['blockconfiguring'] = 'Configuring {$a}';
$string['pluginname'] = 'NED Teacher Tools';
$string['plugintitle'] = 'NED Teacher Tools';
$string['headertitle'] = 'NED Teacher Tools';
$string['blocktitle'] = 'NED Teacher Tools';
$string['cfgdisplaytitle'] = 'Display title';
$string['displaytitle'] = 'Activities Submitted';
$string['generalinfo'] = 'General Info';
$string['timezoneinfo'] = 'Time Zone Info';
$string['gradeslink'] = 'Grades';
$string['show'] = 'Show';
$string['hide'] = 'Hide';
$string['sort'] = 'Sort';
$string['view'] = 'View';
$string['marked'] = 'Graded Activities';
$string['reportslink'] = 'Reports';
$string['showcourselink'] = 'Course home link';
$string['showgradeslink'] = 'Class Progress';
$string['showactivitycompletions'] = 'Student Progress';
$string['showgradebook'] = 'Gradebook';
$string['showkicagradebook'] = 'KICA Gradebook';
$string['gradebook'] = 'Gradebook';
$string['kicagradebook'] = 'KICA Gradebook';
$string['showmarked'] = 'Graded Activities';
$string['showreportslink'] = 'Student List';
$string['showunmarked'] = 'Requires Grading';
$string['showunsubmitted'] = 'Unsubmitted Activities';
$string['ttmarking'] = 'Grading Interface';
$string['notloggedin'] = ' - no login for';
$string['title:failingwithgradelessthanxpercent'] = 'The following students have an overall grade less than ';
$string['title:notlogin'] = 'The Following Students Have Not Logged in For ';
$string['title:notsubmittedanyactivity'] = 'The Following Students Have Not Submitted Any Activities For ';
$string['title:markslessthanxpercent'] = 'The Following Students Have Not Submitted Any Activities For ';
$string['title:saved'] = 'The Following Students Have Draft Activities';
$string['notsubmittedany'] = ' - no submission for {$a} days';
$string['overallfailinggrade'] = ' - grade less than {$a}%';
$string['gradingstudentprogress'] = 'Showing {$a->index} of {$a->count}';
$string['grade'] = '<b>Grade: </b>';
$string['config_title'] = 'Instance title';
$string['config_title_help'] = '<p>This setting allows the block title to be changed.</p>
<p>If the block header is hidden, the title will not appear.</p>';
$string['config_showunmarked'] = 'Show unmarked activities';
$string['config_showunmarked_help'] = '<p>This setting allows whether to show .</p>
<p> or hide the unmarked activities in block.</p>';
$string['config_showmarked'] = 'Show graded activities';
$string['config_showmarked_help'] = '<p>This setting allows whether to show .</p>
<p> or hide the marked activities in block.</p>';
$string['config_showsaved'] = 'Show draft activities';
$string['config_showsaved_help'] = '<p>This setting allows whether to show .</p>
<p> or hide the student draft activities in block.</p>';
$string['config_draft'] = 'Show draft activities';
$string['config_draft_help'] = '<p>This setting allows whether to show .</p>
<p> or hide the student draft activities in block.</p>';
$string['config_unsubmitted'] = 'Show unsubmitted activities';
$string['config_unsubmitted_help'] = '<p>This setting allows whether to show </p>
<p> or hide the not submitted activities in block.</p>';
$string['config_showgradeslink'] = 'Show grade link';
$string['config_showreportlink'] = 'Show report link';
$string['config_showreportlink_help'] = '<p>This setting allows whether to show </p>
<p> or hide the report link in block.</p>';
$string['showstudentnotsubmittedassignment'] = 'Students not submitted for X days';
$string['showstudentnotsubmittedassignment_desc'] = 'This setting allows whether to show or hide the number
of student not submitted assignment last week .';
$string['showstudentmarkslessthanfiftypercent'] = 'Students with overall grade less than X percent';
$string['showstudentmarkslessthanfiftypercent_desc'] = 'This setting allows whether to show or hide the number
of student marks less that 50%.';
$string['config_days'] = 'Set the number of student not logged in x days';
$string['config_days_help'] = '<p>This setting allows to set  </p>
<p>the number of days that student have not logged in course.</p>';
$string['config_percent'] = 'Set the percent of marks';
$string['config_percent_help'] = '<p>This setting allows to set  </p>
<p>the percent of marks and after setting the percent you will see the number of student marks below x percent.</p>';
$string['ned_teacher_tools:addinstance'] = 'Add instance';
$string['ned_teacher_tools:viewblock'] = 'View block';
$string['ned_teacher_tools:viewkicagradebook'] = 'View KICA Gradebook';
$string['ned_teacher_tools:viewreadonly'] = 'MM - View only';
$string['ned_teacher_tools:myaddinstance'] = 'Add a new NED Teacher Tools block to Dashboard';
$string['ned_teacher_tools:add_extension'] = 'DM - Can add extension';
$string['ned_teacher_tools:manage_extensions'] = 'DM - Can manage extensions';
$string['ned_teacher_tools:manage_group_deadlines'] = 'DM - Can manage group deadlines';
$string['ned_teacher_tools:manage_group_requirements'] = 'DM - Can manage "required" column for groups';
$string['ned_teacher_tools:manage_user_deadlines'] = 'DM - Can manage user deadlines';
$string['ned_teacher_tools:manage_user_requirements'] = 'DM - Can manage "required" column for users';
$string['ned_teacher_tools:view_all_groups'] = 'Can see all groups';
$string['ned_teacher_tools:view_extension_detail'] = 'DM - Can view extension details';
$string['ned_teacher_tools:view_own_groups'] = 'Can see own groups';
$string['ned_teacher_tools:deadlineviewonly'] = 'DM - View only';
$string['ned_teacher_tools:ignore_max_extension_limit'] = 'DM - Can ignore max extension limit';
$string['ned_teacher_tools:overriderestrictions'] = 'DM - Override restrictions';
$string['ned_teacher_tools:extendclassstudentenddate'] = 'DM - Can extend class/student end date';
$string['ned_teacher_tools:view_timezone_menu'] = 'DM - View timezone menu';
$string['simplegradebook'] = 'Class Progress';
$string['studentlist'] = 'Student List';
$string['moodlegradebook'] = 'Open Moodle Gradebook';
$string['descconfig'] = '<p>Activate this option to hide all blocks when viewing the NED Teacher Tools interface
and provide a less cluttered look. Note that before activating this option, you will need to add this code
to <b><em>yourmoodlesite/theme/base/config.php</em>.</b></p>
<p></p>
<pre><code style="font-size:12px; color:#FF7600;">
// Hide left and right block columns when viewing the NED Teacher Tools
\'markingmanager\' => array(
      \'file\' => \'general.php\',
      \'regions\' => array(),
      \'options\' => array(\'noblocks\'=>true),
),
</code></pre>
After you add the above code, your file should look like the image <a href="http://moodlefn.com/docs/marking_manager_no_blocks.png">shown here</a>.  ';
$string['labelnoblocks'] = 'Hide all blocks';
$string['showtopmessage'] = 'Show message above interface';
$string['topmessage'] = 'Message to show';
$string['include_orphaned'] = 'Include orphaned (stealth) activities';
$string['forum'] = 'Forum';
$string['quiz'] = 'Quiz';
$string['assign'] = 'Assignment';
$string['feedback'] = 'Feedback';
$string['type'] = 'Type';
$string['scale'] = 'Scale';
$string['whocanrate'] = 'Who can rate';
$string['aggregatetype'] = 'Aggregate type';
$string['student_have_posted'] = 'The following students have posted to this forum:';
$string['student'] = 'Student';
$string['posts'] = 'Posts';
$string['replies'] = 'Replies';
$string['rating'] = 'Rating';
$string['morethan10'] = 'There are more than 10 courses with ungraded work.';
$string['sectiontitles'] = 'Section titles';
$string['sectiontitles_desc'] = 'blank=course default';
$string['version'] = 'Version';
$string['visitpluginhome'] = 'Vist plugin home page';
$string['pluginnametext'] = 'Plug-in name';
$string['pagelayout'] = 'Page layout';
$string['successful'] = 'Successful';
$string['progressreport'] = 'Progress Report';
$string['pageload'] = 'Page load';
$string['cron'] = 'Cron job';
$string['lastrefreshtime'] = 'Last refresh: {$a} ago ';
$string['lastrefreshupdating'] = 'Last refresh: Updating ';
$string['lastrefreshrequired'] = 'Last refresh: Update required ';
$string['name'] = 'Name';
$string['blockinfo'] = 'Block info';
$string['atmaxresubmission'] = 'At max resubmission';
$string['moodledefaultview'] = 'Open in Moodle grader';//
$string['moodledefaultviewuser'] = 'Open {$a} submission in Moodle grader';
$string['overrideexclude'] = 'Override/Exclude';
$string['manualgrading'] = 'Manual Grading';
$string['nograde'] = 'No grade';
$string['includecourses'] = 'Courses to include';
$string['allcourseswithblock'] = 'Only include courses that have the NED Teacher Tools block';
$string['selectedcourses'] = 'Selected courses (below)';
$string['showonlineeditor'] = 'Show online editor';
$string['hideonlineeditor'] = 'Hide online editor';
$string['studentssubmission'] = 'Student\'s Submission';
$string['save'] = 'Save';
$string['teachersfeedback'] = 'Teacher\'s Feedback';
$string['acceptoverride'] = 'Accept override';
$string['removeoverride'] = 'Remove override';
$string['opengradereport'] = 'Open grade report';
$string['help'] = 'Help';
$string['gradeoverridedetected'] = 'Grade override detected';
$string['checkagain'] = 'Check again';
$string['editortoggle'] = 'Online editor toggle';
$string['editortoggle_desc'] = 'Experimental';
$string['allparticipants'] = 'All participants';
$string['allgroups'] = 'All groups';
$string['allclasses'] = 'All classes';
$string['manual'] = 'Manual';
$string['refreshnow'] = 'Refresh now';
$string['yes'] = 'Yes';
$string['no'] = 'No';
$string['enrolledcourses'] = 'Enrolled courses';
$string['allcourses'] = 'All courses';
$string['blocksitesettings'] = 'Block site settings';
$string['opensitesettingspage'] = 'Open site settings page';
$string['showtitles'] = 'Titles for link clusters inside block';
$string['quicklinks'] = 'Quick links';
$string['notices'] = 'Notices';
$string['othersettings'] = 'Other settings';
$string['showlinktogradebook'] = 'Show link to gradebook';
$string['blocktitlesitelevel'] = 'Block title - site level';
$string['blocktitlecourselevel'] = 'Block title - course level';
$string['block_title'] = 'Block title';
$string['teachertools'] = 'Teacher Tools';
$string['generalsettings'] = 'General settings';
$string['suspendeduserstoshow'] = 'Suspended users to show';
$string['none'] = 'None';
$string['suspendedenrollments'] = 'Suspended enrollments';
$string['suspendedusers'] = 'Suspended users';
$string['both'] = 'Both';
$string['includeunsubmittedactivities'] = 'Include unsubmitted activities in final grade';
$string['showsuspendedusers'] = 'Show suspended users';
$string['showinactiveusers'] = 'Show inactive users';
$string['hideinactiveusers'] = 'Hide inactive users';
$string['lockuser'] = 'Lock the users';
$string['unlockuser'] = 'Unlock the user';
$string['showkicaactivities'] = 'Show in KICA Gradebook'; //
$string['customlinks'] = 'Custom Links';
$string['courseresources'] = 'Course resources';
$string['customlinkstitle'] = 'Custom links title';
$string['numberoflinks'] = 'Number of links';
$string['iconcoodes'] = 'Icon codes';
$string['newwindow'] = 'New window';
$string['samewindow'] = 'Same window';
$string['popup'] = 'Pop-up';
$string['iconcode'] = 'Icon code';
$string['title'] = 'Title';
$string['link'] = 'Link';
$string['linkbehaviour'] = 'Link behaviour';
$string['showinstudentmenu'] = 'Also show in Student menu';
$string['minsbeforerefreshrequired'] = 'Minutes before refresh required';
$string['courses'] = 'Course(s)';
$string['listexpiredrefreshrequired'] = 'List has expired. Refresh required.';
$string['truncateactivitynames'] = 'Truncate text in activity names';
$string['customlinksconfigdesc'] = '
<div class="local_ned_controller_menu_customlink-title">Format: <span class="red">icon</span>, <span class="red">title</span>, <span class="red">link</span>, <span class="red">link-behaviour</span></div>
<div class="local_ned_controller_menu_customlink-title">Options:</div>
<div class="local_ned_controller_customlink-item"><strong>icon:</strong> see <a target="_blank" href="https://fontawesome.com/v4.7.0/icons/">https://fontawesome.com/v4.7.0/icons/</a></div>
<div class="local_ned_controller_customlink-item"><strong>link:</strong> use url (<span class="red">http://</span>) or "<span class="red">auto-link</span>" to autolink to activity with same name or "<span class="red">section-link</span>" to link to section with same name</div>
<div class="local_ned_controller_customlink-item"><strong>link-behaviour:</strong> <span class="red">new-window</span>, <span class="red">same-window</span>, <span class="red">pop-up</span></div>
<div class="local_ned_controller_menu_customlink-title">Examples:</div>
<div class="local_ned_controller_customlink-item">fa-cube, My Portfolio, auto-link, same-page</div>
<div class="local_ned_controller_customlink-item">fa-square-o, Teacher Resources, section-link, same-page</div>
<div class="local_ned_controller_customlink-item">fa-square-o, Teacher Communication Log, section-link, same-page</div>
<div class="local_ned_controller_customlink-item">fa-external-link, Moodle, https://moodle.org/, pop-up</div>';
$string['useactivitysetting'] = 'Use activity setting';
$string['usepassgradepercent'] = 'Use pass grade percent';
$string['passgrade'] = 'Pass grade';
$string['passgradepercent'] = 'Pass grade percent';
$string['activitycompletion'] = 'Student Progress';
$string['total'] = 'Total';
$string['activities'] = 'Activities';
$string['activitiescompleted'] = 'Completed Activities';
$string['all'] = 'All';
$string['incomplete'] = 'Incomplete';
$string['incompleted'] = 'Incompleted';
$string['completed'] = 'Completed';
$string['completedunsuccessful'] = 'Completed-unsuccessful';
$string['completedsuccessful'] = 'Completed-successful';
$string['notattempted'] = 'Not Attempted';
$string['waitingforgrade'] = 'Waiting for grade';
$string['noactivitywithstatus'] = 'No activity with status "{$a}"';
$string['noactivitybyfilters'] = 'No activity by such filters';
$string['noactivity'] = 'No activity';
$string['activityname'] = 'Activity Name';
$string['activitytype'] = 'Activity type';
$string['yourgrade'] = 'Your grade';
$string['selectstudent'] = 'Select student';
$string['selectgroup'] = 'Select group';
$string['selectgroup_help']
    = 'You can select a group to calculate grades and other metrics or you may leave this setting as "Select group" to decrease page loading time.';
$string['never'] = 'Never';
$string['grade_'] = 'Grade';
$string['offlineactivity_title'] = 'This activity was completed offline';
$string['overrideactivity_title'] = 'Grade override';
$string['gradebooklink'] = 'When KICA Gradebook is enabled, show this gradebook link';
$string['moodle'] = 'Moodle';
$string['kica'] = 'KICA';
$string['replacewithkicagrade']
    = 'When KICA Gradebook is enabled, replace Moodle grades with KICA grades in Class Overview and Student Overview pages';
$string['graded_kica'] = 'Graded with KICA';
$string['ungraded_kica'] = 'Waiting for KICA';
$string['completedsucessfully'] = 'Completed successfully';
$string['completedunsucessfully'] = 'Completed unsuccessfully';
$string['passed'] = 'Completed';
$string['draftnotsubmitted'] = 'Draft (not submitted)';
$string['submitted'] = 'Submitted';
$string['academy_integrity_flag'] = 'Academy Integrity Flag';
$string['excluded'] = 'Excluded activity';
$string['kica_zerograde'] = 'Zero grade';
$string['alltags'] = 'All tags';
$string['nonetags'] = 'Without tags';
$string['havealltags'] = 'Have all tags';
$string['choosetag'] = 'Choose tag';
$string['choosesort'] = 'Sort';
$string['confirm'] = 'Confirm';
$string['complete'] = 'Complete!';
$string['returntosettings'] = 'Return to settings';
$string['deadlinemanager'] = 'Deadline Manager';
$string['enabledeadlinemanager'] = 'Enable Deadline Manager';
$string['activitieswithdeadlines'] = 'Activities with deadlines';
$string['makeassignmentduecutoffsame'] = 'Make assignment due date and cut-off date the same';
$string['autozero'] = 'Automatically apply a zero grade when there is no submission before deadline';
$string['rolesingroup'] = 'Roles to show in group pages';
$string['enabledeadlineextension'] = 'Enable deadline extensions';
$string['mindaysbeforeextension'] = 'Minimum days before deadline to accept extension';
$string['reportid'] = 'Report ID';
$string['studentswithowndeadline'] = 'Students with own deadlines';
$string['classroomteacher'] = 'Classroom Teacher';
$string['onlineteacher'] = 'Online Teacher';
$string['id'] = 'ID';
$string['firstdeadline'] = 'First Due';
$string['lastdeadline'] = 'Last Due';
$string['students'] = 'Students';
$string['allusers'] = 'All users';
$string['listallusers'] = 'List all users';
$string['submittedontime'] = 'Submitted on time';
$string['deadline_past'] = $string['misseddeadline'] = 'Missed Deadline';
$string['extensionsgranted'] = 'Extensions';
$string['countdown'] = 'Countdown';
$string['deadline'] = 'Deadline';
$string['managedeadlines'] = 'Manage deadlines';
$string['overview'] = 'Overview';
$string['group'] = 'Group';
$string['source'] = 'Source';
$string['currentgrade'] = 'Current grade';
$string['give_zero_after_deadline'] = 'Award zero grade after deadline';
$string['auto_set_waiting_for_grade'] = 'Auto set “waiting for grade” status';
$string['auto_set_waiting_for_internal_review'] = 'Auto set “waiting for internal review” status';
$string['overriden'] = 'Overriden';
$string['notoverriden'] = 'Not Overriden';
$string['nooverridengroup'] = 'There is no overriden group.';
$string['nooverridenuser'] = 'There is no overriden user.';
$string['nooverridenactivityingroup'] = 'There is no overriden activity in this group.';
$string['defaultdeadlinesource'] = 'Default date - {$a}';
$string['activitiestomanage'] = 'Activities to manage';
$string['editlist'] = 'Edit list';
$string['defaultsectionname'] = 'Section-{$a}';
$string['submit'] = 'Submit';
$string['requiredschedule'] = 'Required';
$string['full'] = 'Full';
$string['optional'] = 'Optional';
$string['none'] = 'None';
$string['summativeactivities'] = 'Summative Activities';
$string['formativeactivities'] = 'Formative Activities';
$string['participationpower'] = 'Participation Power';
$string['participationpower_option'] = 'Enable Participation power';
$string['clearcache'] = 'Clear Cache';
$string['clearcache_text'] = 'Clear cached NED Teachers Block Data (Safe: Can not affect your website in any way)';
$string['extension'] = 'Extension';
$string['activityextension'] = 'Extension';
$string['extensions'] = 'Extensions';
$string['missedschedulefooter'] = 'Your course schedule is not complete. Click <a href="{$a}">here</a> to review.';
$string['duedaterequired'] = 'Due date required';
$string['open'] = 'Open';
$string['returntott'] = 'Return to Teacher Tools block configuration';
$string['resubmissions'] = 'Resubmissions';
$string['enableresubmissions'] = 'Enable Resubmissions manager';
$string['resubmissioncriteria'] = 'Resubmission criteria';
$string['participationpowerrequired'] = 'Participation power required to resubmit';
$string['participationpowerrequired_desc'] = 'When Participation power is equal or greater then this value, user can resubmit';
$string['maximumattemptsincourse'] = 'Maximum resubmissions in course<br>(submission + resubmissions)';
$string['maximumattempts'] = 'Maximum attempts per assignment<br>(submission + resubmissions)';
$string['daysforresubmission'] = 'Number of days to accept resubmission after a grade is awarded';
$string['zeroisinfinity'] = 'Zero - is infinity';
$string['manage'] = 'Manage';
$string['tags'] = 'Tags';
$string['reopen'] = 'Reopen';
$string['resubmitted'] = 'Resubmitted';
$string['regraded'] = 'Regraded';
$string['missingdeadlinetooltip'] = 'Some due dates are missing. Click on the Open button to review.';
$string['resubmissionsmanager'] = 'Resubmissions Manager';
$string['reopen'] = 'Reopen';
$string['resubmitted'] = 'Resubmitted';
$string['regraded'] = 'Regraded';
$string['resubmit'] = 'Resubmit';
$string['resubmit_title'] = 'Get one more attempt in this Assignment';
$string['resubmit_time_title'] = 'Time left until you can resubmit';
$string['resubmit_time_title'] = 'Time left until you can resubmit';
$string['resubmit_pp_error'] = 'Not enough Participation power ({$a->{0}}/{$a->{1}})!';
$string['resubmit_course_attempts_error'] = 'You have no remaining attempts in course ({$a->{0}}/{$a->{1}})!';
$string['resubmit_attempts_error'] = 'You have no remaining attempts in this assignment (used {$a->{0}}/{$a->{1}})!';
$string['ask_to_resubmit'] = 'Ask to Resubmit';
$string['ask_to_resubmit:error'] = 'You can\'t  resubmit "{$a}".';
$string['ask_to_resubmit:error:is_off'] = 'Resubmission is off for this Assignment.';
$string['ask_to_resubmit:error:no_records'] = 'Can\'t find the necessary records.';
$string['ask_to_resubmit:error:not_graded'] = 'Your last assignment even is not graded yet.';
$string['ask_to_resubmit:error:time_is_over'] = 'Your time for resubmission is over.';
$string['currentgrade'] = 'Current grade';
$string['resubmissionused'] = 'Resubmissions used';
$string['iconlegend'] = 'Icon Legend';
$string['currentduedate'] = 'Current due date';
$string['duedate'] = 'Due date';
$string['reasonforextension'] = 'Reason for extension';
$string['maxextensionperstudent'] = 'Maximum extension per student in this course';
$string['maxextensionperactivity'] = 'Maximum extension per activity per student';
$string['numofgraded'] = 'Number of graded';
$string['numofzeros'] = 'Number of zero graded';
$string['allstudents'] = 'All students';
$string['deadlinemanagerisnotenabled'] = 'The Deadline Manager is not enabled';
$string['norequiredgroupfound']
    = 'The Deadline Manager is not enabled for your group(s). Please contact your Academic Manager if you have any questions';
$string['viewgradebook'] = 'View gradebook';
$string['notavailableforuser'] = 'This activity is not available for this user.';
$string['reason'] = 'Reason';
$string['extendedduedate'] = 'Extended due date';
$string['originalduedate'] = 'Original due date';
$string['studentprogress'] = 'Student Progress';
$string['removefilter'] = 'Remove filter';
$string['extensionconfirmation'] = '<p>If a student has a valid reason for missing a due date, he or she may request a Due Date Extension. It is the
    responsibility of the Classroom Teacher to ensure that students do not take advantage of this privilege.</p>
    <br></p>
<p class="text-center" style="color: red;">Do you wish to grant an extension for this student?</p>';
$string['opensmth'] = 'Open "{$a}"';
$string['bulk_add'] = 'Add tags to selected items';
$string['bulk_remove'] = 'Remove tags from selected items';
$string['saved'] = 'Draft';
$string['start'] = 'Start';
$string['end'] = 'End';
$string['groupdeadlinedateerror'] = 'Deadline must occur within course start-end dates.';
$string['coursestartend'] = 'Course Start-End';
$string['dm'] = 'DM';
$string['dateconflict'] = 'Date conflict';
$string['filter_by_name_text'] = 'Keyword';
$string['filter_by_name_start'] = 'Show only names, which starts with keyword';
$string['filter_by_name_case'] = 'Ignore case';
$string['filter_by_resources'] = 'Resource';
$string['filter_by_activities'] = 'Activity';
$string['filter_by_tags'] = 'Tag';
$string['filter_none_found'] = 'No activities found by your filters';
$string['filter_clear_filter'] = 'Clear filters';
$string['unused_resubmissions_manager'] = 'Unused Resubmissions Manager';
$string['unusedresubmissions_' . NED::RESUBMISSIONS_ALL]
    = 'There are {$a->records_count} unused resubmissions in {$a->courses_count} courses on whole site';
$string['unusedresubmissions_' . NED::RESUBMISSIONS_MADE_BY_RM]
    = 'There are {$a->records_count} unused resubmissions in {$a->courses_count} courses, made by RM.';
$string['unusedresubmissions_' . NED::RESUBMISSIONS_MADE_BY_RM_CONTROLLED_BY_RM]
    = 'There are {$a->records_count} unused resubmissions in {$a->courses_count} courses, made by RM, in activities, which are now controlled by RM';
$string['unusedresubmissions_' . NED::RESUBMISSIONS_MADE_BY_RM_CONTROLLED_NOT_BY_RM]
    = 'There are {$a->records_count} unused resubmissions in {$a->courses_count} courses, made by RM, in activities, which are now not controlled by RM';
$string['unusedresubmissions_' . NED::RESUBMISSIONS_MADE_NOT_BY_RM]
    = 'There are {$a->records_count} unused resubmissions in {$a->courses_count} courses, made not by RM';
$string['unusedresubmissions_' . NED::RESUBMISSIONS_MADE_NOT_BY_RM_CONTROLLED_BY_RM]
    = 'There are {$a->records_count} unused resubmissions in {$a->courses_count} courses, made not by RM, in activities, which are now controlled by RM';
$string['unusedresubmissions_' . NED::RESUBMISSIONS_MADE_NOT_BY_RM_CONTROLLED_NOT_BY_RM]
    = 'There are {$a->records_count} unused resubmissions in {$a->courses_count} courses, made not by RM, in activities, which are now not controlled by RM';
$string['showdetails'] = 'Show details';
$string['details'] = 'Details';
$string['remove'] = 'Remove';
$string['action'] = 'Action';
$string['removeresubmissionswarn'] = 'Are you sure you want to remove these resubmissions?\nIt can\'t be undone.';
$string['unusedresubmissions_removed_successfully'] = '{$a->count} unused resubmissions have been successfully removed.';
$string['unusedresubmissions_removed_successfully_one'] = 'Unused resubmission in {$a->activity} has been successfully removed.';
$string['unusedresubmissions_removed_error'] = 'There was some error {$a->error}.';
$string['madebyrm'] = 'Made by RM';
$string['controlledbyrm'] = 'Controlled by RM';
$string['unusedresubmissions'] = 'Unused resubmissions';
$string['daysopen'] = 'Days Open';
$string['nostudents'] = 'No Students'; //
$string['duedates'] = 'Due dates'; //
$string['past'] = 'Past';
$string['missing'] = 'Missing';
$string['upcoming'] = 'Upcoming';
$string['notsubmittedfilter'] = 'Filter';
$string['notsubmittedfilter_help'] = 'This panel filters "Not Submitted" table by due date.';
$string['marking_status'] = 'Status';
$string['gotonewmmpage'] = 'Go to new Marking Manager page';
$string['returnto'] = 'Return to "{$a}"';
$string['savedsuccessfully'] = 'Saved successfully';
$string['removedsuccessfully'] = 'Removed successfully';
$string['edit'] = 'Edit';
$string['reviewattempt'] = 'Review attempt';
$string['reviewresponse'] = 'Review response';
$string['incorrect'] = 'Incorrect';
$string['correct'] = 'Correct';
$string['partiallycorrect'] = 'Partially correct';
$string['notyetgraded'] = 'Not yet graded';
$string['moreoptions'] = 'More options';
$string['ned_assign:nopermission'] = 'Sorry, but you do not currently have permissions to do that.';
$string['ned_assign:notdraft'] = 'This submission isn\'t draft';
$string['ned_assign:notsubmitted'] = 'This submission isn\'t submitted';
$string['ned_assign:unexpectederror'] = 'Some unexpected error.';
$string['timemodified'] = 'Last changes';
$string['loading'] = 'Loading, please wait...';
$string['externalmodal'] = 'External links in modal window are forbidden!';
$string['courseinprogress'] = 'Course in progress';
$string['coursecompletepass'] = 'Course complete - Pass';
$string['coursecompletefail'] = 'Course complete - Fail';
$string['coursecompletewffg'] = 'Course complete - Waiting for final grade';
$string['coursecompletewffir'] = 'Course complete - Waiting for internal review';
$string['coursewithdrawn'] = 'Course withdrawn';
$string['studentonhold'] = 'Student on hold';
$string['selectcompletionstatus'] = 'Select completion status:';
$string['choosethestatus'] = 'Choose the status';
$string['errorchengestatustopass']
    = 'The following users were unable to change their status to "pass" because they have not yet completed the course: ';
$string['coursecompletionstatuscontroller'] = 'Course Completion Status Controller';
$string['enablecoursecompletionstatuscontroller'] = 'Enable course completion status controller';
$string['enablecoursecompletionstatuscontroller_desc'] = 'Global on/off';
$string['coursecompletionstatuscontroller_coursecategories'] = 'Enabled courses categories';
$string['coursecompletionstatuscontroller_coursecategories_desc']
    = 'Select the categories, which courses should be enabled for Completion Status Controller';
$string['ned_teacher_tools:managecompletionstatus'] = 'Manage Course Completion Status Controller';
$string['ned_teacher_tools:seecoursegradewhilewaitingforfinalgrade'] = 'See course grade while waiting for final grade';
$string['errorpermissionschengestatustopass'] = 'Not enough permissions to change "Pass" status:';
$string['coursecompletion'] = 'Course Completion';
$string['ungraded_kica_formative'] = $string['ungraded_kica_summative'] = $string['submitedwfg'] = 'Submitted - Waiting for Grade';
$string['graded_kica_formative'] = $string['completedsuccessful2'] = 'Completed - Successful';
$string['incompleted_formative'] = $string['completedunsuccessful2'] = 'Completed - Unsuccessful';
$string['graded_kica_summative'] = $string['gradedsuccessful'] = 'Grade - Successful';
$string['incompleted_summative'] = $string['gradedunsuccessful'] = 'Grade - Unsuccessful';
$string['general'] = 'General';
$string['autosetwfgstatus'] = 'Auto set “waiting for grade” status';
$string['autosetwfirstatus'] = 'Auto set “waiting for internal review” status';
$string['coursecompletionstatusmanager'] = 'Course Completion Status Manager';
$string['coursename'] = 'Course name';
$string['coursecode'] = 'Course code';
$string['csm'] = 'Csm';
$string['completioncriteria'] = 'Completion criteria';
$string['completionstatus'] = 'Completion status';
$string['badge'] = 'Badge';
$string['ccsm_na'] = 'N/A';
$string['ccsm_grade'] = 'Grade';
$string['nocoursesavailable'] = 'No courses available';
$string['review_modal:title'] = 'Grading in progress...';
$string['review_modal:body']
    = 'The final exam was submitted and grading is currently in progress. Once a grade has been awarded, you will have 5 days to review the exam.';
$string['review_modal:button'] = 'Okay, I Understand';
$string['maximumtwoactivities'] = 'A maximum of 2 activities can have the same due-date';
$string['allowunordered'] = 'Allow due dates that do not follow the order of activities';
$string['forcequizsequence'] = 'Force quiz due dates to follow sequence in course';
$string['assigneddateordererror'] = 'Assigned dates must follow the order of activities';
$string['startend'] = 'Start-End';
$string['daysleft'] = 'Days left';
$string['classstudentenddateextension'] = 'Allow class/student end date extension';
$string['maxdaysbetween'] = 'Total maximum days between start-end date';
$string['currentenddate'] = 'Current end date';
$string['newenddate'] = 'New end date';
$string['schoolid'] = 'School ID';
$string['dayswaiting'] = 'Days waiting';
$string['waitinggrade'] = 'Waiting grade';
$string['waitinginternalreview'] = 'Waiting internal review';
$string['day'] = 'day';
$string['days'] = 'days';
$string['multiple'] = 'Multiple';
$string['activestudents'] = '{$a->active} Active {$a->role}';
$string['inactivestudents'] = '{$a->active} Active and <span class="tt-inactive"> {$a->inactive} Inactive</span> {$a->role}';
$string['countclassroomteacher'] = '{$a} Classroom Teachers';
$string['countonlineteacher'] = '{$a} Online Teachers';
$string['showgeneralinfosection'] = 'Show General Info section';
$string['showsummativeactivitiessection'] = 'Show Summative Activities section';
$string['showformativeactivitiessection'] = 'Show Formative Activities section';
$string['showformativesummativeicons'] = 'Show Formative/Summative icons';
$string['showduedatecolumn'] = 'Show Due date column';
$string['showtagsfilter'] = 'Show Tags Filter';
$string['seeallrateddiscussion'] = 'Click to see all rated discussion.';
$string['openforum'] = 'Open Forum';
$string['maxdayerror'] = 'New date was not saved. Classes cannot be longer than {$a} days.';

$string['gradingtracker'] = 'Grading Monitor';
$string['gradingtracker_page'] = 'Grading Monitor page';
$string['ned_teacher_tools:gradingtracker_seeown'] = 'Grading Monitor: see own grader records';
$string['ned_teacher_tools:gradingtracker_seeall'] = 'Grading Monitor: see all records';
$string['ned_teacher_tools:gradingtracker_canhide'] = 'Grading Monitor: hide activities from grade report';
$string['gradingtracker_coursecategories'] = 'Enable course categories Grading Monitor';
$string['gradingtracker_coursecategories_desc'] = 'Select the categories, which courses should be enabled for Grading Monitor';
$string['gradingtracker_manystudents'] = 'Large school threshold';
$string['gradingtracker_manystudents_desc'] = 'An extra day is added to the grading window in school that have this many students';
$string['gradingtracker_activitiestags3days'] = 'Activity with 3 days';
$string['gradingtracker_activitiestags3days_desc'] = 'Activity tags with 3 day grading window';
$string['gradingtracker_activitiestags5days'] = 'Activity with 5 days';
$string['gradingtracker_activitiestags5days_desc'] = 'Activity tags with 5 day grading window';
$string['gradingtracker_weekend'] = 'Grading Monitor Holidays';
$string['gradingtracker_weekend_desc']
    = "Keywords in site calendar events that GM should count as day off for grader.<br>One per line, case-sensitive.";
$string['gradingtracker_statisticdate'] = 'Statistics start date';
$string['gradingtracker_statisticdate:error'] = 'There is wrong value in the "Statistics start date", please, check your settings.';
$string['gradingtracker_statisticdate_desc'] = 'DD/MM/YYYY';
$string['waitingforgrade'] = 'Waiting for grade';
$string['ontime'] = 'On time';
$string['late'] = 'Late';
$string['timeleft'] = '{$a} Remaining';
$string['totaloverdue'] = 'Total Overdue';
$string['overdue24'] = 'Overdue +24hrs';
$string['overdue_x'] = '+{$a} Overdue';
$string['overdue_uncounted_x'] = '+{$a}';
$string['waitingforgrade_grade'] = 'Waiting for Grade';
$string['ontime_grade'] = 'Graded on Time';
$string['late_grade'] = 'Grade Late';
$string['overdue_grade'] = 'Grade Overdue';
$string['activitydeadline'] = 'Activity Deadline';
$string['gradestatus'] = 'Grade Status';
$string['gradername'] = 'Grader Name';
$string['studentname'] = 'Student Name';
$string['submissiontime'] = 'Submission time';
$string['gradebeforetime'] = 'Grade before';
$string['gradetime'] = 'Grade time';
$string['note'] = 'Note';
$string['grader'] = 'Grader';
$string['status'] = 'Status';
$string['period'] = 'Period';
$string['otgradedue'] = 'OT Grade Due';
$string['otgradeawarded'] = 'OT Grade Awarded';
$string['update'] = 'Update';
$string['updated'] = 'Updated';
$string['messagerecalculation'] = 'Are you sure you want to recalculate? Large number of records can take some time to update.';
$string['availabilitywindow'] = 'DM - Activity Availability Window';
$string['numberofactivitieshavesamedue'] = 'Number of activities that can have same due date';
$string['days_x'] = '{$a} Days';
$string['months_x'] = '{$a} Months';
$string['expanded'] = 'Expanded';
$string['compact'] = 'Compact';
$string['days_short'] = 'D';
$string['perpage'] = 'Items per page';
$string['school'] = 'School';
$string['aboutgt'] = 'About the Grading Monitor';
$string['update_records_x'] = 'Check & update up to {$a} record(s)';
$string['checked_updated_records'] = 'Successfully have checked {$a->all} record(s): {$a->changed} of them have been updated, '
    . '{$a->removed} of them have been removed.';
$string['successrate'] = 'Success Rate';
$string['midtermdate'] = 'Midterm Date';
$string['midtermaftererror'] = 'Must have a due date that is BEFORE midterm activity due date';
$string['midtermbeforeerror'] = 'Must have a due date that is AFTER midterm activity due date';
$string['enablemidtermpoint'] = 'Enable midterm point';
$string['quickgrade'] = 'Quick Grade';
$string['mylocalschooltime'] = 'My Local School Time';
$string['rosedaleofficetime'] = 'Rosedale Office Time';
$string['rosedaleoffice'] = 'Rosedale Office';
$string['localschool'] = 'Local School';
$string['timezoneview'] = 'Timezone View';
$string['strtimeformat'] = '%d %b %Y @ %I:%M%p';
$string['differenttimezonewarning'] = 'Warning - At least one user in this class is using a different timezone';
$string['classinfo'] = 'Class Info';
$string['timezoneinfo'] = 'Timezone Info';
$string['studentinfo'] = 'Student Info';
$string['editschooltimezones'] = 'Edit school timezones';
$string['quickgrade'] = 'Quick grade';
$string['active'] = 'Active';
$string['activeusers'] = 'Active users';
$string['suspendedusers'] = 'Suspended users';
$string['quickfeedback'] = 'Quick Feedback';
$string['openforumgrader'] = 'Open Forum Grader';
$string['assignstudentroletocts'] = 'Assign Student role to CTs';
$string['unlimited'] = 'Unlimited';
$string['addnewextension'] = 'Add new extension';
$string['activitynotdm'] = 'This activity is not available in the Deadline Manager';
$string['notallowed'] = 'Access Denied';
$string['reportbug'] = 'Report a bug';
$string['unreportbug'] = 'Remove the bug report';
$string['bugreport'] = 'Bug report';
$string['askbugreport'] = 'Please explain why you think this submission is not being reported correctly.';
$string['askunsetbugreport'] = 'Do you want to remove the bug report from this record?';
$string['setuncounted'] = 'Do not count grading time';
$string['setcounted'] = 'Count grading time';
$string['uncounted'] = 'Grading time not counted';
$string['asksetuncounted'] = 'Please explain why the grading time should not be counted for this submission.';
$string['asksetcounted'] = 'Do you want to count the grading time for this submission again?';
$string['gthide'] = 'Hide from Grading Monitor';
$string['gtshow'] = 'Show in Grading Monitor';
$string['gthidden'] = 'Hidden';
$string['askgthide'] = 'Please explain why this submission should be hidden from the Grading Monitor.';
$string['askgtshow'] = 'Do you want to show this submission in the Grading Monitor?';
$string['courseforupdate'] = '{$a} course(s) for update:';
$string['coursecmforupdate'] = 'There are {$a->courses} course(s) and {$a->cms} activities for update:';
$string['quizzestoregrade'] = 'There are {$a} quizzes to regrade.';
$string['recalculationactivity'] = 'Recalculation activity {$a->name} ({$a->done}/{$a->count})';
$string['recalculatedsuccessfully'] = 'Successfully recalculated ({$a->done}/{$a->count})';
$string['updatecms'] = 'Update course modules';
$string['updatequizzes'] = 'Update quizzes';
$string['updatedsuccessfully'] = 'Completed successfully';
$string['unexpectederror'] = 'Some unexpected error.';
$string['updatescripts'] = 'Update scripts';
$string['showclassroomteachers'] = 'Show Classroom Teachers';
$string['hideclassroomteachers'] = 'Hide Classroom Teachers';
$string['activitybulksettingschanger'] = 'Activity Bulk Settings Changer';
$string['locatedincoursecategory'] = 'And is located in a course in this category';
$string['applysettings'] = 'Apply Settings';
$string['applythesesettings'] = 'Then apply these settings';
$string['completedwarningtext'] = 'If activity has already been marked as completed for any participant(s), 
changing completion options will erase their completion state and may cause confusion. 
This option should be changed with caution.';
$string['completion_not_change'] = "Don't change activity completion";
$string['updateactivity'] = 'Update activity {$a->name} ({$a->done}/{$a->count})';
$string['changetags'] = 'Change activity tags';
$string['changetags_desc'] = 'Rewrite activity tags by next field. If that field is be empty, it removes all activity tags.';
$string['cmcourse_error'] = 'Some error with cm "{$a->cmname}" ({$a->cmid}) in the course "{$a->coursename}" ({$a->courseid}).';
$string['noactivitiesbyfilter'] = 'There are no activities that match your filter criteria.';
$string['cronjobs'] = 'Cronjobs';
$string['crongt_hourly_task'] = 'Cron GM';
$string['crongt_enable'] = 'Enable GM update cronjob';
$string['crongt_hour'] = 'GM cronjob start';
$string['crongt_hour_desc'] = 'Start time for GM update cronjob (24h clock, Eastern time)';
$string['crongt_delay'] = 'GM update delay';
$string['crongt_delay_desc'] = 'Time delay (in minutes) between GM record updates';
$string['blocklinks'] = 'Block links';
$string['blockcontenterror'] = 'There is a problem with "' . $string['pluginname'] . '", please report it to site admin.';
$string['removesubmissiondata'] = 'Delete all submission data';
$string['submissionremoved'] = 'Submission «{$a}» has been successfully removed.';
$string['submissioncantremoved'] = '«{$a}» can\'t be removed.';
$string['allowresubmission'] = 'Allow Resubmission';
$string['resubmissionadded'] = 'Resubmission «{$a}» has been successfully added.';
$string['resubmissioncantadded'] = 'Resubmission «{$a}» can\'t be added.';
$string['gradeoverridden'] = 'Grade overridden';
$string['nedgradingpage'] = 'Ned grading page';
$string['gradingpage'] = 'Grading page';
$string['latesubmission'] = 'Late submission';
$string['permissionerror'] = 'Permission error!';
$string['timezone_info_school'] = 'All dates are shown in school time zone: {$a->timezone} ({$a->now})';
$string['timezone_info_student'] = 'All dates are shown in student time zone: {$a->timezone} ({$a->now})';
$string['timezone_info_server'] = 'All dates are shown in server time zone: {$a->timezone} ({$a->now})';
$string['timezone_info_user'] = 'Your time zone is {$a->timezone} ({$a->now})';
$string['schools'] = 'Schools';
