<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    local_ned_controller
 * @subpackage NED
 * @copyright  2018 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @developer  G J Barnard - {@link http://about.me/gjbarnard} and
 *                           {@link http://moodle.org/user/profile.php?id=442195}
 */

defined('MOODLE_INTERNAL') || die();

global $ADMIN;
// Ensure the configurations for this site are set
if ($hassiteconfig){
    $settings = null; // Unsets the default $settings object initialised by Moodle.

    // Create own category and define pages.
    $ADMIN->add('localplugins', new admin_category('local_ned_controller', 'NED Controller'));

    /* Create the new settings page
       - in a local plugin this is not defined as standard, so normal $settings->methods will throw an error as
       $settings will be NULL */
    $settings = new admin_settingpage('local_ned_controller_controlpanel', get_string('controlpanel', 'local_ned_controller'));

    // Initialise individual settings only if admin pages require them.
    if ($ADMIN->fulltree) {
        global $CFG;
        if (file_exists("{$CFG->dirroot}/local/ned_controller/ned_controller_admin_setting_categoryicons.php")) {
            require_once($CFG->dirroot . '/local/ned_controller/ned_controller_admin_setting_categoryicons.php');
        }

        // Category icon setting.
        $name = 'local_ned_controller/categoryicons';
        $title = get_string('categoryicons', 'local_ned_controller');
        $description = get_string('categoryiconsformat', 'local_ned_controller').
            get_string('categoryiconscategory', 'local_ned_controller').', '.
            get_string('categoryiconsfontawesome', 'local_ned_controller').
            get_string('categoryiconssemi', 'local_ned_controller');
        $default = '';
        $setting = new ned_controller_admin_setting_categoryicons($name, $title, $description, $default);
        $setting->set_updatedcallback('theme_reset_all_caches');  // Used by NED themes.
        $settings->add($setting);

        // Quick links in the course header.
        $settings->add(new admin_setting_heading('local_ned_controller_quicklinkscourseheader_heading',
            get_string('quicklinkscourseheader', 'local_ned_controller'), ''));

        // Manual enrollment.
        $name = 'local_ned_controller/quicklinkscourseheadermanualenrollment';
        $title = get_string('quicklinksmanualenrollment', 'local_ned_controller');
        $description = get_string('quicklinksmanualenrollment_desc', 'local_ned_controller');
        $default = false;
        $setting = new admin_setting_configcheckbox($name, $title, $description, $default, true, false);
        // No CSS change, so no need to reset caches.
        $settings->add($setting);

        // Course participants.
        $name = 'local_ned_controller/quicklinkscourseheadercourseparticpants';
        $title = get_string('quicklinkscourseparticpants', 'local_ned_controller');
        $description = get_string('quicklinkscourseparticpants_desc', 'local_ned_controller');
        $default = false;
        $setting = new admin_setting_configcheckbox($name, $title, $description, $default, true, false);
        // No CSS change, so no need to reset caches.
        $settings->add($setting);

        // Quick links in next to the course name.
        $settings->add(new admin_setting_heading('local_ned_controller_quicklinkscoursename_heading',
            get_string('quicklinkscoursename', 'local_ned_controller'), ''));

        // Edit settings.
        $name = 'local_ned_controller/quicklinkscoursenameeditsettings';
        $title = get_string('quicklinkseditsettings', 'local_ned_controller');
        $description = get_string('quicklinkseditsettings_desc', 'local_ned_controller');
        $default = false;
        $setting = new admin_setting_configcheckbox($name, $title, $description, $default, true, false);
        // No CSS change, so no need to reset caches.
        $settings->add($setting);

        // Manual enrollment.
        $name = 'local_ned_controller/quicklinkscoursenamemanualenrollment';
        $title = get_string('quicklinksmanualenrollment', 'local_ned_controller');
        $description = get_string('quicklinksmanualenrollment_desc', 'local_ned_controller');
        $default = false;
        $setting = new admin_setting_configcheckbox($name, $title, $description, $default, true, false);
        // No CSS change, so no need to reset caches.
        $settings->add($setting);

        // Course participants.
        $name = 'local_ned_controller/quicklinkscoursenamecourseparticpants';
        $title = get_string('quicklinkscourseparticpants', 'local_ned_controller');
        $description = get_string('quicklinkscourseparticpants_desc', 'local_ned_controller');
        $default = false;
        $setting = new admin_setting_configcheckbox($name, $title, $description, $default, true, false);
        // No CSS change, so no need to reset caches.
        $settings->add($setting);

        // NED Progress report.
        $name = 'local_ned_controller/quicklinkscoursenamenedprogressreport';
        $title = get_string('quicklinksnedprogressreport', 'local_ned_controller');
        $description = get_string('quicklinksnedprogressreport_desc', 'local_ned_controller');
        $default = false;
        $setting = new admin_setting_configcheckbox($name, $title, $description, $default, true, false);
        // No CSS change, so no need to reset caches.
        $settings->add($setting);

        // NED Marking Manager.
        $name = 'local_ned_controller/quicklinkscoursenamenedmarkingmanager';
        $title = get_string('quicklinksnedmarkingmanager', 'local_ned_controller');
        $description = get_string('quicklinksnedmarkingmanager_desc', 'local_ned_controller');
        $default = false;
        $setting = new admin_setting_configcheckbox($name, $title, $description, $default, true, false);
        // No CSS change, so no need to reset caches.
        $settings->add($setting);

        // NED Student Menu.
        $name = 'local_ned_controller/quicklinkscoursenamenedstudentmenu';
        $title = get_string('quicklinksnedstudentmenu', 'local_ned_controller');
        $description = get_string('quicklinksnedstudentmenu_desc', 'local_ned_controller');
        $default = false;
        $setting = new admin_setting_configcheckbox($name, $title, $description, $default, true, false);
        // No CSS change, so no need to reset caches.
        $settings->add($setting);

        // Gradebook.
        $name = 'local_ned_controller/quicklinkscoursenamegradebook';
        $title = get_string('quicklinksgradebook', 'local_ned_controller');
        $description = get_string('quicklinksgradebook_desc', 'local_ned_controller');
        $default = false;
        $setting = new admin_setting_configcheckbox($name, $title, $description, $default, true, false);
        // No CSS change, so no need to reset caches.
        $settings->add($setting);

    }

    //$ADMIN->add('local_ned_controller', $settings);

    $ADMIN->add('localplugins',
        new admin_externalpage('local_ned_controller_overview',
            get_string('pluginname', 'local_ned_controller'),
            new moodle_url('/local/ned_controller/index.php')
        )
    );
}

