<?php
    /**
     * @package    local_ned_controller
     * @subpackage NED
     * @copyright  2018 NED {@link http://ned.ca}
     * @author     NED {@link http://ned.ca}
     * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
     * @developer  G J Barnard - {@link http://about.me/gjbarnard} and
     *                           {@link http://moodle.org/user/profile.php?id=442195}
     */

    require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
    require_once($CFG->dirroot.'/local/ned_controller/lib.php');
    require_once($CFG->dirroot.'/local/ned_controller/index_form.php');

    $check = optional_param('check', 0, PARAM_INT);

// Security.
    $context = context_system::instance();
    require_login();
    require_capability('moodle/site:config', $context);

// Page boilerplate stuff.
    $PAGE->set_context($context);
    // wrong url to trick navbar
    $url = new moodle_url('/local/ned_controller/index.php');
    $PAGE->set_url($url);
    $title = get_string('nedcontrollersettings', 'local_ned_controller');
    $settings_url = new moodle_url(local_ned_controller_get_setting_local_urlpath('ned_controller'));
    $PAGE->navbar->add($title, $settings_url);
    $PAGE->set_pagelayout('admin');
    $PAGE->set_title($title);
    $PAGE->set_heading($title);

// Set up the form.
    $mform = new local_ned_controller_settings_form();
    $sucessmsg = false;

    if ($mform->is_cancelled()) {
        redirect($settings_url);
    } else {
        if ($data = $mform->get_data()){
            foreach ($data as $name => $value){
                if ($name == 'categoryicons'){
                    $value = local_ned_controller_encode($value);
                }
                set_config($name, $value, 'local_ned_controller');
                $sucessmsg = true;
            }

        }

        if ($settings = get_config('local_ned_controller')){
            if (property_exists($settings, 'categoryicons')){
                $settings->categoryicons = local_ned_controller_decode($settings->categoryicons);
            }
            $mform->set_data($settings);
        }

    }

    echo $OUTPUT->header();
    if ($sucessmsg){
        echo $OUTPUT->notification(get_string('changessaved'), 'notifysuccess');
    }
    $mform->display();
    echo $OUTPUT->footer();