<?php

/**
 * @package      local_proxy
 * @subpackage   NED
 * @copyright    2020 NED {@link http://ned.ca}
 * @author       NED {@link http://ned.ca}
 * @license      http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 *
 * @noinspection PhpUnused
 */
namespace local_proxy;

defined('MOODLE_INTERNAL') || die();

use local_proxy\helper;

/**
 * Event observers.
 */
class observer {
    /**
     * @param \mod_assign\event\course_module_viewed $event
     */
    public static function course_module_viewed(\mod_assign\event\course_module_viewed $event) {
        global $USER, $SESSION;

        $data = $event->get_data();

        if (!$assigns = helper::get_proxy_assignments($data['courseid'])) {
            return;
        }

        $proxyenabled = false;
        foreach ($assigns as $assign) {
            if ($assign->assignment == $data['objectid']) {
                $proxyenabled = true;
                break;
            }
        }
        if (!$proxyenabled) {
            return;
        }

        $action = optional_param('action', '', PARAM_TEXT);
        $prevpage = optional_param('prevpage', '', PARAM_TEXT);

        if ($prevpage && $action == 'grading') {
            $SESSION->proxy[$data['contextinstanceid']] = 1;
            return;
        }

        if (isset($SESSION->proxy[$data['contextinstanceid']]) && $action == 'grading') {
            return;
        }

        $context = \context::instance_by_id($data['contextid']);

        if (has_capability('assignsubmission/proxy:submit', $context, $USER->id, false)) {
            redirect(new \moodle_url('/local/proxy/submission.php', ['id' => $data['contextinstanceid']]));
        }
    }
}
