<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Contains class local_proxy\output\renderer
 *
 * @package    local_proxy
 * @copyright 2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_proxy\output;

defined('MOODLE_INTERNAL') || die();

/**
 * Class renderer
 * @package local_proxy\output
 */
class renderer extends \plugin_renderer_base {
    /**
     * @param proxy_submission $proxysubmission
     * @return bool|string
     * @throws \moodle_exception
     */
    public function render_submission_header(proxy_submission $proxysubmission){
        $data = $proxysubmission->export_for_template($this);
        return $this->render_from_template('local_proxy/proxy_submission', $data);
    }
}
