<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Proxy Overview.
 *
 * @package   local_proxy
 * @copyright 2021 Michael Gardener <mgardener@cissq.com>
 * @license   http://www.gnu.org/copyleft/gpl.html gnu gpl v3 or later
 */

use local_proxy\shared_lib as NED;

require_once(dirname(__FILE__, 3) . '/config.php');
require_once($CFG->dirroot . '/mod/assign/locallib.php');
require_once($CFG->dirroot . '/blocks/ned_teacher_tools/common_data_utils.php');

$id = required_param('id', PARAM_INT);
$groupid = optional_param('group', null, PARAM_INT);
$submissionstatus = optional_param('submissionstatus', 'allclasses', PARAM_TEXT);
$gradingstatus = optional_param('gradingstatus', 'gradingstatusall', PARAM_TEXT);

$course = $DB->get_record('course', ['id' => $id], '*', MUST_EXIST);

require_login($course);

$context = context_course::instance($course->id);

require_capability('assignsubmission/proxy:manage', $context);

$url = new moodle_url('/mod/assign/view.php', ['id' => $id]);
NED::page_set_title('proxyoverview', $url);

$overview = new \local_proxy\output\proxy_overview($course, $groupid, $submissionstatus, $gradingstatus);

echo $OUTPUT->header();
echo NED::render($overview);
echo $OUTPUT->footer();