<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Proxy submission.
 *
 * @package   local_proxy
 * @copyright 2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html gnu gpl v3 or later
 */

use local_proxy\shared_lib as NED;

require_once(dirname(__FILE__, 3) . '/config.php');
require_once($CFG->dirroot . '/mod/assign/locallib.php');

$id = required_param('id', PARAM_INT);
$groupid = optional_param('groupid', 0, PARAM_INT);

list ($course, $cm) = get_course_and_cm_from_cmid($id, 'assign');

require_login($course, true, $cm);

$context = context_module::instance($cm->id);

require_capability('assignsubmission/proxy:submit', $context);

$assign = new assign($context, $cm, $course);

/** @var assign_submission_proxy $assignsubmissionproxy */
$assignsubmissionproxy  = $assign->get_submission_plugin_by_type('proxy');
$cfg = $assignsubmissionproxy->get_config();

if (empty($cfg->enabled)){
    NED::print_module_error('invalidmodule');
}

$urlparams = array('id' => $id);

$url = new moodle_url('/local/proxy/submission.php', $urlparams);
NED::page_set_title('proxysubmission', $url);
$submission = new \local_proxy\output\proxy_submission($assign, $groupid);

echo $OUTPUT->header();
echo NED::render($submission);
echo $OUTPUT->footer();