<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Infraction Form
 *
 * @package    local_tem
 * @copyright  2023 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_tem\form;

use local_tem\helper;

defined('MOODLE_INTERNAL') || die();

/** @var object $CFG */
require_once($CFG->libdir . '/formslib.php');
require_once($CFG->dirroot . '/mod/assign/submission/proxy/locallib.php');

/**
 * Class infraction
 * @package local_tem\form
 */
class report extends \moodleform {

    public function definition() {
        global $OUTPUT, $USER;

        $mform = $this->_form;

        $customdate = $this->_customdata;
        $sameip = $customdate['sameip'];
        $staticiptype = $customdate['staticiptype'];
        $hasuncompletedattempts = $customdate['hasuncompletedattempts'];
        $edit = $customdate['edit'];
        $instance = $customdate['instance'];
        $id = $instance->id ?? 0;
        $irregulareventviolation = $instance->irregulareventviolation ?? 0;
        $sameroom = $instance->sameroom ?? 0;
        $contextsystem = \context_system::instance();

        $numberofproctorsoptions = [];
        for ($i = 1; $i <= 10; $i++ ) {
            $numberofproctorsoptions[$i] = $i;
        }

        $mform->addElement('select', 'numberofproctors', get_string('numberofproctors', 'local_tem'), $numberofproctorsoptions);

        $mform->addElement('selectyesno', 'sameroom', get_string('sameroom', 'local_tem'));

        if ($edit || !$id) {
            $mform->addElement('textarea', 'sameroomreason', get_string('sameroomreason', 'local_tem'), 'wrap="virtual" rows="3" cols="50"');
            $mform->hideIf('sameroomreason', 'sameroom', 'eq', '1');
            if (!$sameip) {
                $mform->addElement('textarea', 'differentipreason', get_string('differentipreason', 'local_tem'), 'wrap="virtual" rows="3" cols="50"');
                $mform->hideIf('differentipreason', 'sameroom', 'eq', '0');
            }
        } else {
            if (!$sameroom) {
                $mform->addElement('textarea', 'sameroomreason', get_string('sameroomreason', 'local_tem'), 'wrap="virtual" rows="3" cols="50"');
                $mform->hideIf('sameroomreason', 'sameroom', 'eq', '1');
            } else {
                if (!$sameip) {
                    $mform->addElement('textarea', 'differentipreason', get_string('differentipreason', 'local_tem'), 'wrap="virtual" rows="3" cols="50"');
                    $mform->hideIf('differentipreason', 'sameroom', 'eq', '0');
                }
            }
        }

        $mform->addElement('selectyesno', 'irregulareventviolation', get_string('irregulareventviolation', 'local_tem'));

        if (($edit || !$id) || $irregulareventviolation) {
            $mform->addElement('textarea', 'irregulareventviolationreason', get_string('irregulareventviolationreason', 'local_tem'), 'wrap="virtual" rows="3" cols="50"');
            $mform->hideIf('irregulareventviolationreason', 'irregulareventviolation', 'eq', '0');
        }

        $fileoptions = $this->get_file_options();

        if ($edit || !$id) {
            $mform->addElement('filemanager', 'files_filemanager', '', null, $fileoptions);
            $mform->hideIf('files_filemanager', 'irregulareventviolation', 'eq', '0');
        } else {
            if ($irregulareventviolation && $out = helper::get_reort_file_links($instance->sessionid)) {
                $mform->addElement('static', 'attachmentlinks', '', implode('<br>', $out));
            }
        }

        if ($hasuncompletedattempts) {
            $mform->addElement('textarea', 'noattemptreason', get_string('noattemptreason', 'local_tem'), 'wrap="virtual" rows="3" cols="50"');
        }

        if ($edit || !$id) {
            $mform->addElement('text', 'linktovideorecording', get_string('linktovideorecording', 'local_tem'));
            $mform->setType('linktovideorecording', PARAM_URL);
        } else {
            $videolink = '';
            if (!empty($instance->linktovideorecording)) {
                $videolink = \html_writer::link($instance->linktovideorecording, $instance->linktovideorecording);
            }
            $mform->addElement('static', 'linktovideorecordinglink', get_string('linktovideorecording', 'local_tem'), $videolink);
        }

        $a = new \stdClass();
        $a->name = fullname($USER);
        $a->date = date('m/d/Y');

        $mform->addElement('html', $OUTPUT->render_from_template('local_tem/report_agreement', [
            'signaturetext' => get_string('signaturetext', 'local_tem', $a)
        ]));

        if ($edit || !$id) {
            $signaturegroup = array();
            $signaturegroup[] =& $mform->createElement('text', 'signaturetext', '', ['disabled' => 'disabled']);
            $signaturegroup[] =& $mform->createElement('button', 'sign', get_string('clickheretosign', 'local_tem'));
            $mform->setType('signaturetext', PARAM_TEXT);
            $mform->addGroup($signaturegroup, 'signaturegroup', '', array(' '), false);
        } else {
            $mform->addElement('text', 'signaturetext', '', ['disabled' => 'disabled', 'id' => 'signature-static']);
            $mform->setType('signaturetext', PARAM_TEXT);
        }
        $mform->addElement('html', '<div class="resolution-wrapper">');

        if ($id && !$edit && has_capability('local/tem:manageflaggedsessions', $contextsystem) && !empty($irregulareventviolation)) {
            $mform->addElement('select', 'resolutionstatus', get_string('resolutionstatus', 'local_tem'), \local_tem\report::resolution_status_options());
            $mform->hideIf('resolutionstatus', 'irregulareventviolation', 'eq', '0');

            $mform->addElement('select', 'resolutionseverity', get_string('resolutionseverity', 'local_tem'), \local_tem\report::resolution_severity_options());
            $mform->hideIf('resolutionseverity', 'irregulareventviolation', 'eq', '0');

            $mform->addElement('textarea', 'resolutionnote', get_string('resolutionnote', 'local_tem'), 'wrap="virtual" rows="3" cols="50"');
            $mform->hideIf('resolutionnote', 'irregulareventviolation', 'eq', '0');
        }

        $mform->addElement('hidden', 'edit');
        $mform->setType('edit', PARAM_INT);

        $mform->addElement('hidden', 'returnurl');
        $mform->setType('returnurl', PARAM_LOCALURL);

        $mform->addElement('hidden', 'signature');
        $mform->setType('signature', PARAM_RAW);

        $mform->addElement('hidden', 'sessionid');
        $mform->setType('sessionid', PARAM_INT);

        $this->add_action_buttons(true, get_string('submit'));

        if ($id && !$edit) {
            $except = ['resolutionstatus', 'resolutionseverity', 'resolutionnote', 'submitbutton', 'cancel'];
            $mform->hardFreezeAllVisibleExcept($except);
            if (!empty($irregulareventviolation)) {
                $this->add_action_buttons(true, get_string('submit'));
            }
        }

        $mform->addElement('html', '</div>');
    }

    /**
     * @param array $data
     * @param array $files
     * @return array
     */
    public function validation($data, $files){
        $errors = array();
        return $errors;
    }

    /**
     * File format options
     *
     * @return array
     */
    public function get_file_options() {
        global $CFG;
        $fileoptions = array(
            'subdirs' => 1,
            'maxfiles'   => EDITOR_UNLIMITED_FILES,
            'maxbytes'   => $CFG->maxbytes,
            'accepted_types' => '*',
            'return_types' => (FILE_INTERNAL | FILE_CONTROLLED_LINK));
        return $fileoptions;
    }
}
