<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * report_header
 *
 * @package    local_proxy
 * @copyright  2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_tem\output;


use local_tem\report;
use moodle_url;

defined('MOODLE_INTERNAL') || die();

/**
 * Class proxy_overview
 * @package local_proxy\output
 */
class report_header implements \renderable, \templatable {
    /**
     * @var report
     */
    private $report;
    /**
     * @var moodle_url
     */
    private $formurl;
    private $edit;

    public function __construct(report $report, $edit, moodle_url $formurl) {
        $this->report = $report;
        $this->formurl = $formurl;
        $this->edit = $edit;
    }

    /**
     * Export page contents for template
     * @param \renderer_base $output
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output){
        $data = new \stdClass();
        $data->coursename = $this->report->course->shortname;
        $data->classname = $this->report->group->name;
        $data->quizname = $this->report->quiz->name;
        $data->dateofattempt = date('m/d/Y', $this->report->session->timestart);
        $this->formurl->param('edit', 1);
        $data->formurl = $this->formurl->out(false);
        $data->displayeditbtn = $this->display_edit_button();
        return $data;
    }

    /**
     * @return bool
     */
    public function display_edit_button(): bool {
        if (!isset($this->report->instance->id) || $this->edit) {
            return false;
        }
        return true;
    }
}
