<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Grader Info.
 *
 * @package   local_worksheet
 * @copyright 2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html gnu gpl v3 or later
 */

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');

$courseid = optional_param('course', 0, PARAM_INT);
$quizid = optional_param('quiz', 0, PARAM_INT);
$showquestions = optional_param('showquestions', false, PARAM_BOOL);
$search = optional_param('search', '', PARAM_TEXT);

require_login(null, false);

$contextsystem = context_system::instance();

// Permission.
//require_capability('local/package:manage', $contextsystem);

if (empty($courseid)) {
    $quizid = 0;
}

if (isset($SESSION->graderinfocourse)) {
    if ($SESSION->graderinfocourse != $courseid) {
        $quizid = 0;
    }
}
$SESSION->graderinfocourse = $courseid;

$thispageurl = new moodle_url('/local/worksheet/graderinfo.php');

$PAGE->set_url($thispageurl);
$PAGE->set_pagelayout('course');
$PAGE->set_context($contextsystem);

$name = get_string('graderinfo', 'local_worksheet');
$title = get_string('graderinfo', 'local_worksheet');
$heading = $SITE->fullname;

// Breadcrumb.
$PAGE->navbar->add($title, $thispageurl);

$PAGE->set_title($title);
$PAGE->set_heading($heading);

echo $OUTPUT->header();
echo html_writer::tag('h1', $title, array('class' => 'page-title'));

$renderer = $PAGE->get_renderer('local_worksheet');

$filter = new local_worksheet\output\filter($courseid, $quizid, $showquestions, $search);
$graderinfo = new local_worksheet\output\graderinfo($quizid, $showquestions, $search);

echo $renderer->render($filter);
echo $renderer->render($graderinfo);

echo $OUTPUT->footer();