<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Class Level Notification
 *
 * @package    assignsubmission_ctsubmission
 * @copyright  2022 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace assignsubmission_ctsubmission\output;

use assignsubmission_ctsubmission\shared_lib as NED;
use assignsubmission_ctsubmission\submission;
use assignsubmission_ctsubmission\helper;

defined('MOODLE_INTERNAL') || die();

/** @var object $CFG */
require_once($CFG->dirroot . '/mod/assign/locallib.php');

/**
 * Class proxy_overview
 * @package assignsubmission_ctsubmission\output
 */
class ct_notification implements \renderable, \templatable {
    /**
     * @var \stdClass $course
     */
    protected $course;

    /**
     * ct_notification constructor.
     *
     * @param object $course
     */
    public function __construct($course){
        $this->course = $course;
    }

    /**
     * Export page contents for template
     * @param \renderer_base $output
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output){
        return new \stdClass(); // It is.
    }
}
