<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Contains class assignsubmission_ctsubmission\output\renderer
 *
 * @package    assignsubmission_ctsubmission
 * @copyright 2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace assignsubmission_ctsubmission\output;

defined('MOODLE_INTERNAL') || die();

/**
 * Class renderer
 * @package assignsubmission_ctsubmission\output
 */
class renderer extends \plugin_renderer_base {
    /**
     * @param ct_submission $ctsubmission
     * @return bool|string
     * @throws \moodle_exception
     */
    public function render_submission_header(ct_submission $ctsubmission){
        $data = $ctsubmission->export_for_template($this);
        return $this->render_from_template('assignsubmission_ctsubmission/ct_submission', $data);
    }
}
