<?php
/**
 * @package    assignsubmission_ctsubmission
 * @subpackage NED
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace assignsubmission_ctsubmission;

defined('MOODLE_INTERNAL') || die();

/**
 * Class submission
 * @package assignsubmission_ctsubmission
 */
class submission extends \core\persistent implements \cacheable_object  {

    /** Table name for the persistent. */
    const TABLE = 'assignsubmission_ctsubmis';

    /**
     * Return the definition of the properties of this model.
     *
     * @return array
     */
    protected static function define_properties() {
        return array(
            'assignment' => array(
                'type' => PARAM_INT,
            ),
            'submission' => array(
                'type' => PARAM_INT,
            ),
            'approved' => array(
                'type' => PARAM_INT,
            ),
        );
    }

    /**
     * Prepares the object for caching. Works like the __sleep method.
     *
     * @return mixed The data to cache, can be anything except a class that implements the cacheable_object... that would
     *      be dumb.
     */
    public function prepare_to_cache() {
        return $this->to_record();
    }

    /**
     * Takes the data provided by prepare_to_cache and reinitialises an instance of the associated from it.
     *
     * @param mixed $data
     * @return object The instance for the given data.
     */
    public static function wake_from_cache($data) {
        return new self(0, $data);
    }
}
